<?php
$text_align_options = array( 
	esc_html__( 'Left', 'js_composer' ) => 'left', 
	esc_html__( 'Right', 'js_composer' ) => 'right', 
	esc_html__( 'Center', 'js_composer' ) => 'center', 
	esc_html__( 'Justify', 'js_composer' ) => 'justify' );

// Single product page builder
vc_map( 
	array( 
		"name" => esc_html__( "Single Product Image", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_image", 
		"category" => esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array(
			array(
				"type" => "dropdown",
				"heading" => esc_html__( 'Sale Flash', 'woocommerce' ),
				"param_name" => "sale_flash",
				'value' => array(
					esc_html__( 'Yes', 'js_composer' ) => 'yes',
					esc_html__( 'No', 'js_composer' ) => 'no',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__( 'Gallery Style', 'dt_woocommerce_page_builder' ),
				"param_name" => "product_gallery_type",
				'value' => array(
					esc_html__( 'Theme default', 'dt_woocommerce_page_builder' ) => '',
					esc_html__( 'Gallery Slider', 'dt_woocommerce_page_builder' ) => 'gallery-slider',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__( 'Gallery Slider Style', 'dt_woocommerce_page_builder' ),
				"param_name" => "gallery_slider_style",
				'value' => array(
					esc_html__( 'Horizontal', 'dt_woocommerce_page_builder' ) => 'horizontal',
					esc_html__( 'Vertical', 'dt_woocommerce_page_builder' ) => 'vertical',
				),
				'dependency' => array( 'element' => 'product_gallery_type', 'value' => 'gallery-slider' )
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__( 'Gallery Thumbnails Style', 'dt_woocommerce_page_builder' ),
				"param_name" => "gallery_thumbs_vertical",
				'value' => array(
					esc_html__( 'Left', 'js_composer' ) => 'left',
					esc_html__( 'Right', 'js_composer' ) => 'right',
				),
				'dependency' => array( 'element' => 'gallery_slider_style', 'value' => 'vertical' )
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__( 'Thumbnails to show', 'dt_woocommerce_page_builder' ),
				"param_name" => "thumbs_show",
				'value' => '4',
				'dependency' => array( 'element' => 'product_gallery_type', 'value' => 'gallery-slider' )
			),
			
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

/*
 * Support WooCommerce Product Configurator by Iconic
 */
if ( class_exists( 'jckpc' ) ) {
	vc_map( 
		array( 
			"name" => esc_html__( 
				"Iconic Product Configurator Image",
				'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_single_product_iconic-wpc-gallery", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"description" => '', 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => esc_html__( "Hover Zoom effect", 'dt_woocommerce_page_builder' ),
					"param_name" => "zoom_img",
					'value' => array(
					esc_html__( 'Yes', 'js_composer' ) => '',
					esc_html__( 'No', 'js_composer' ) => 'no-zoom_img',
					),
				),
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

/*
 * Support WooThumbs - Awesome Product Imagery by Iconic
 */
if ( class_exists( 'Iconic_WooThumbs' ) ) {
	vc_map( 
		array( 
			"name" =>esc_html__( 
				"Iconic WooThumbs - Awesome Product Imagery",
				'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_product_woothumbs-gallery", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"description" => '', 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

vc_map( 
	array( 
		"name" => esc_html__( "Single Product Title", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_title", 
		"category" => esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "HTML Tag", 'dt_woocommerce_page_builder' ), 
				"param_name" => "tag", 
				'std' => 'h1', 
				'value' => array( 
					'h1' => 'h1', 
					'h2' => 'h2', 
					'h3' => 'h3', 
					'h4' => 'h4', 
					'h5' => 'h5', 
					'h6' => 'h6', 
					'p' => 'p', 
					'div' => 'div' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => $text_align_options ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Font size', 'js_composer' ), 
				'param_name' => 'font_size', 
				'description' => esc_html__( 'Enter font size.', 'dt_woocommerce_page_builder' ) )

			, 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Line height', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'line_height', 
				'description' => esc_html__( 'Enter line height.', 'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'colorpicker', 
				'heading' => esc_html__( 'Color', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'color' ), 
			array( 
				'type' => 'checkbox', 
				'heading' => esc_html__( 'Use theme default font family?', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'use_fonts', 
				'value' => array( esc_html__( 'No', 'dt_woocommerce_page_builder' ) => 'no' ), 
				'description' => esc_html__( 'Use font family from the theme.', 'dt_woocommerce_page_builder' ) )

			, 
			array( 
				'type' => 'google_fonts', 
				'param_name' => 'google_fonts', 
				'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal', 
				'settings' => array( 
					'fields' => array( 
						'font_family_description' => esc_html__( 'Select font family.', 'dt_woocommerce_page_builder' ), 
						'font_style_description' => esc_html__( 'Select font styling.', 'dt_woocommerce_page_builder' ) ) ), 
				'dependency' => array( 'element' => 'use_fonts', 'value' => 'no' ) ), 
			vc_map_add_css_animation(), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Rating", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_rating", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Price", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_price", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => $text_align_options ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Font size', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'font_size', 
				'description' => esc_html__( 'Enter font size.', 'dt_woocommerce_page_builder' ) )

			, 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Line height', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'line_height', 
				'description' => esc_html__( 'Enter line height.', 'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'colorpicker', 
				'heading' => esc_html__( 'Color', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'color' ), 
			array( 
				'type' => 'checkbox', 
				'heading' => esc_html__( 'Use theme default font family?', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'use_fonts', 
				'value' => array( esc_html__( 'No', 'dt_woocommerce_page_builder' ) => 'no' ), 
				'description' => esc_html__( 'Use font family from the theme.', 'dt_woocommerce_page_builder' ) )

			, 
			array( 
				'type' => 'google_fonts', 
				'param_name' => 'google_fonts', 
				'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal', 
				'settings' => array( 
					'fields' => array( 
						'font_family_description' => esc_html__( 'Select font family.', 'dt_woocommerce_page_builder' ), 
						'font_style_description' => esc_html__( 'Select font styling.', 'dt_woocommerce_page_builder' ) ) ), 
				'dependency' => array( 'element' => 'use_fonts', 'value' => 'no' ) ), 
			vc_map_add_css_animation(), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Excerpt", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_excerpt", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => $text_align_options ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Font size', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'font_size', 
				'description' => esc_html__( 'Enter font size.', 'dt_woocommerce_page_builder' ) )

			, 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Line height', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'line_height', 
				'description' => esc_html__( 'Enter line height.', 'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'colorpicker', 
				'heading' => esc_html__( 'Color', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'color' ), 
			array( 
				'type' => 'checkbox', 
				'heading' => esc_html__( 'Use theme default font family?', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'use_fonts', 
				'value' => array( esc_html__( 'No', 'dt_woocommerce_page_builder' ) => 'no' ), 
				'description' => esc_html__( 'Use font family from the theme.', 'dt_woocommerce_page_builder' ) )

			, 
			array( 
				'type' => 'google_fonts', 
				'param_name' => 'google_fonts', 
				'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal', 
				'settings' => array( 
					'fields' => array( 
						'font_family_description' => esc_html__( 'Select font family.', 'dt_woocommerce_page_builder' ), 
						'font_style_description' => esc_html__( 'Select font styling.', 'dt_woocommerce_page_builder' ) ) ), 
				'dependency' => array( 'element' => 'use_fonts', 'value' => 'no' ) ), 
			vc_map_add_css_animation(), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Add To Cart", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_add_to_cart", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

/*
 * Support WooCommerce Memberships
 * Sell memberships that provide access to restricted content, products, discounts, and more!
 * By: WooCommerce
 * Author: SkyVerge
 * Author URI: https://www.woocommerce.com/
 */
if ( class_exists( 'WC_Memberships_Loader' ) ) {
	
	vc_map( 
		array( 
			"name" =>esc_html__( "WC Memberships: Product Purchasing Discount", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_single_product_display_product_purchasing_discount_message", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"description" =>esc_html__( 
				"Displays member discount message for a product or product variation.", 
				'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
	vc_map( 
		array( 
			"name" =>esc_html__( "WC Memberships: Product Purchasing Restricted", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_single_product_display_product_purchasing_restricted_message", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"description" =>esc_html__( "Displays product purchasing restricted message.", 'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Continue Shopping", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_continue_shopping_button", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Continue Shopping button text", 'dt_woocommerce_page_builder' ), 
				"param_name" => "continue_shopping_text", 
				'value' => '', 
				'std' =>esc_html__( "Continue Shopping", 'dt_woocommerce_page_builder' ), 
				"description" =>esc_html__( "Add Continue Shopping Button", 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Meta", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_meta", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Share", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_share", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Tabs", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_tabs", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Additional Information", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_additional_information", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product Description", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_description", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "dropdown", 
				"heading" => esc_html__( "Text align", 'dt_woocommerce_page_builder' ), 
				"param_name" => "text_align", 
				'value' => $text_align_options ), 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Font size', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'font_size', 
				'description' => esc_html__( 'Enter font size.', 'dt_woocommerce_page_builder' ) )

			, 
			array( 
				'type' => 'textfield', 
				'heading' => esc_html__( 'Line height', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'line_height', 
				'description' => esc_html__( 'Enter line height.', 'dt_woocommerce_page_builder' ) ), 
			array( 
				'type' => 'colorpicker', 
				'heading' => esc_html__( 'Color', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'color' ), 
			array( 
				'type' => 'checkbox', 
				'heading' => esc_html__( 'Use theme default font family?', 'dt_woocommerce_page_builder' ), 
				'param_name' => 'use_fonts', 
				'value' => array( esc_html__( 'No', 'dt_woocommerce_page_builder' ) => 'no' ), 
				'description' => esc_html__( 'Use font family from the theme.', 'dt_woocommerce_page_builder' ) )

			, 
			array( 
				'type' => 'google_fonts', 
				'param_name' => 'google_fonts', 
				'value' => 'font_family:Abril%20Fatface%3Aregular|font_style:400%20regular%3A400%3Anormal', 
				'settings' => array( 
					'fields' => array( 
						'font_family_description' => esc_html__( 'Select font family.', 'dt_woocommerce_page_builder' ), 
						'font_style_description' => esc_html__( 'Select font styling.', 'dt_woocommerce_page_builder' ) ) ), 
				'dependency' => array( 'element' => 'use_fonts', 'value' => 'no' ) ), 
			vc_map_add_css_animation(), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" => esc_html__( "Single Product Reviews", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_reviews", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" => esc_html__( "Single Product Related Products", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_related_products", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Product Per Page", 'dt_woocommerce_page_builder' ), 
				"param_name" => "posts_per_page", 
				"value" => 4 ), 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "columns", 
				"value" => 4 ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Products Ordering", 'dt_woocommerce_page_builder' ), 
				"param_name" => "orderby", 
				'class' => '', 
				"value" => array( 
					__( 'Random', 'dt_woocommerce_page_builder' ) => 'rand', 
					__( 'Publish Date', 'dt_woocommerce_page_builder' ) => 'date', 
					__( 'Modified Date', 'dt_woocommerce_page_builder' ) => 'modified', 
					__( 'Alphabetic', 'dt_woocommerce_page_builder' ) => 'title', 
					__( 'Popularity', 'dt_woocommerce_page_builder' ) => 'popularity', 
					__( 'Rate', 'dt_woocommerce_page_builder' ) => 'rating', 
					__( 'Price', 'dt_woocommerce_page_builder' ) => 'price' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Products order", 'dt_woocommerce_page_builder' ), 
				"param_name" => "order", 
				'class' => '', 
				"value" => array( 
					__( 'DESC', 'dt_woocommerce_page_builder' ) => 'desc', 
					__( 'ASC', 'dt_woocommerce_page_builder' ) => 'asc' ) ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

vc_map( 
	array( 
		"name" =>esc_html__( "Single Product up-sells", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_upsells", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Product Per Page", 'dt_woocommerce_page_builder' ), 
				"param_name" => "posts_per_page", 
				"value" => - 1 ), 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Columns", 'dt_woocommerce_page_builder' ), 
				"param_name" => "columns", 
				"value" => 4 ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Products Ordering", 'dt_woocommerce_page_builder' ), 
				"param_name" => "orderby", 
				'class' => '', 
				"value" => array( 
					__( 'Random', 'dt_woocommerce_page_builder' ) => 'rand', 
					__( 'Publish Date', 'dt_woocommerce_page_builder' ) => 'date', 
					__( 'Modified Date', 'dt_woocommerce_page_builder' ) => 'modified', 
					__( 'Alphabetic', 'dt_woocommerce_page_builder' ) => 'title', 
					__( 'Popularity', 'dt_woocommerce_page_builder' ) => 'popularity', 
					__( 'Rate', 'dt_woocommerce_page_builder' ) => 'rating', 
					__( 'Price', 'dt_woocommerce_page_builder' ) => 'price' ) ), 
			array( 
				"type" => "dropdown", 
				"heading" =>esc_html__( "Products order", 'dt_woocommerce_page_builder' ), 
				"param_name" => "order", 
				'class' => '', 
				"value" => array( 
					__( 'DESC', 'dt_woocommerce_page_builder' ) => 'desc', 
					__( 'ASC', 'dt_woocommerce_page_builder' ) => 'asc' ) ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );

/*
 * Support WooCommerce WishLists plugin
 * https://woocommerce.com/products/woocommerce-wishlists/
 /
if( class_exists('WC_Wishlists_Plugin') ){
	vc_map( 
		array( 
			"name" =>esc_html__( "WooCommerce WishLists Add to wishlist", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_wc_wishlists_add_to_wishlist_button", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array(
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}
*/
/*
 * Support YITH WooCommerce Wishlist plugin
 */
if ( defined( 'YITH_WCWL' ) ) {
	vc_map( 
		array( 
			"name" =>esc_html__( "YITH WooCommerce Wishlist Single Add To Wishlist", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_yith_wcwl_add_to_wishlist", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

/*
 * Support YITH WooCommerce Compare plugin
 */
if ( defined( 'YITH_WOOCOMPARE' ) ) {
	if ( get_option( 'yith_woocompare_compare_button_in_product_page' ) == 'yes' )
		vc_map( 
			array( 
				"name" =>esc_html__( "YITH WooCommerce Compare Single Add Compare Link", 'dt_woocommerce_page_builder' ), 
				"base" => "dtwpb_yith_woocompare_compare_button_in_product_page", 
				"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
				"icon" => "dt-vc-icon-dt_woo", 
				"params" => array( 
					array( 
						"type" => "textfield", 
						"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
						"param_name" => "el_class", 
						'value' => '', 
						"description" =>esc_html__( 
							"If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 
							'dt_woocommerce_page_builder' ) ), 
					array( 
						'type' => 'css_editor', 
						'heading' => esc_html__( 'CSS box', 'js_composer' ), 
						'param_name' => 'css', 
						'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

/*
 * Support WooCommerce_Germanized plugin
 */
if ( class_exists( 'WooCommerce_Germanized' ) ) {
	if ( get_option( 'woocommerce_gzd_display_product_detail_unit_price' ) == 'yes' )
		vc_map( 
			array( 
				"name" =>esc_html__( "WooCommerce Germanized Single Price Unit", 'dt_woocommerce_page_builder' ), 
				"base" => "dtwpb_gzd_template_single_price_unit", 
				"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
				"icon" => "dt-vc-icon-dt_woo", 
				"params" => array( 
					array( 
						"type" => "textfield", 
						"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
						"param_name" => "el_class", 
						'value' => '', 
						"description" =>esc_html__( 
							"If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 
							'dt_woocommerce_page_builder' ) ), 
					array( 
						'type' => 'css_editor', 
						'heading' => esc_html__( 'CSS box', 'js_composer' ), 
						'param_name' => 'css', 
						'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
	
	if ( get_option( 'woocommerce_gzd_display_product_detail_tax_info' ) == 'yes' ||
		 get_option( 'woocommerce_gzd_display_product_detail_shipping_costs' ) == 'yes' )
		vc_map( 
			array( 
				"name" =>esc_html__( "WooCommerce Germanized Single Legal Info", 'dt_woocommerce_page_builder' ), 
				"base" => "dtwpb_gzd_template_single_legal_info", 
				"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
				"icon" => "dt-vc-icon-dt_woo", 
				"params" => array( 
					array( 
						"type" => "textfield", 
						"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
						"param_name" => "el_class", 
						'value' => '', 
						"description" =>esc_html__( 
							"If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 
							'dt_woocommerce_page_builder' ) ), 
					array( 
						'type' => 'css_editor', 
						'heading' => esc_html__( 'CSS box', 'js_composer' ), 
						'param_name' => 'css', 
						'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
	
	if ( get_option( 'woocommerce_gzd_display_product_detail_delivery_time' ) == 'yes' )
		vc_map( 
			array( 
				"name" =>esc_html__( "WooCommerce Germanized Single Delivery Time Info", 'dt_woocommerce_page_builder' ), 
				"base" => "dtwpb_gzd_template_single_delivery_time_info", 
				"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
				"icon" => "dt-vc-icon-dt_woo", 
				"params" => array( 
					array( 
						"type" => "textfield", 
						"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
						"param_name" => "el_class", 
						'value' => '', 
						"description" =>esc_html__( 
							"If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 
							'dt_woocommerce_page_builder' ) ), 
					array( 
						'type' => 'css_editor', 
						'heading' => esc_html__( 'CSS box', 'js_composer' ), 
						'param_name' => 'css', 
						'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

/*
 * Support German Market plugin
 */
if ( class_exists( 'Woocommerce_German_Market' ) ) {
	vc_map( 
		array( 
			"name" =>esc_html__( "German Market: print tax hint", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_wgm_de_price_with_tax_hint", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

/*
 * Support WooCommerce Simple Auction plugin
 */
if ( class_exists( 'WooCommerce_simple_auction' ) ) {
	
	vc_map( 
		array( 
			"name" =>esc_html__( "WooCommerce Simple Auction Bid", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_woocommerce_auction_bid", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
	
	vc_map( 
		array( 
			"name" =>esc_html__( "WooCommerce Simple Auction Pay", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_woocommerce_auction_pay", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"description" =>esc_html__( 
				"Display when the user logged in and have won the auction", 
				'dt_woocommerce_page_builder' ), 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

/*
 * Support WooCommerce Frontend Manager - WC Lovers
 */
if ( class_exists( 'WCFM' ) ) {
	vc_map( 
		array( 
			"name" =>esc_html__( "Single Product WooCommerce Frontend Manager Enquiry Button", 'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_single_product_wcfm_enquiry_button", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"description" => '', 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

/*
 * Support WooCommerce Multivendor Marketplace - WC Lovers
 */
if ( class_exists( 'WCFMmp' ) ) {
	vc_map( 
		array( 
			"name" =>esc_html__( 
				"Single Product WooCommerce Multivendor Marketplace Show Sold by", 
				'dt_woocommerce_page_builder' ), 
			"base" => "dtwpb_single_product_wcfmmp_sold_by_single_product", 
			"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
			"description" => '', 
			"icon" => "dt-vc-icon-dt_woo", 
			"params" => array( 
				array( 
					"type" => "textfield", 
					"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
					"param_name" => "el_class", 
					'value' => '', 
					"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
				array( 
					'type' => 'css_editor', 
					'heading' => esc_html__( 'CSS box', 'js_composer' ), 
					'param_name' => 'css', 
					'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );
}

/*
 * Product custom key
 */
vc_map( 
	array( 
		"name" =>esc_html__( "WooCommerce Product custom key", 'dt_woocommerce_page_builder' ), 
		"base" => "dtwpb_single_product_custom_key", 
		"category" =>esc_html__( "Woo Page Builder", 'dt_woocommerce_page_builder' ), 
		"description" =>esc_html__( "Display Product Custom Field", 'dt_woocommerce_page_builder' ), 
		"icon" => "dt-vc-icon-dt_woo", 
		"params" => array( 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Label", 'dt_woocommerce_page_builder' ), 
				"param_name" => "product_custom_key_label", 
				'value' => '', 
				"description" =>esc_html__( "Enter label to display before key value.", 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "textfield", 
				"heading" =>esc_html__( "Product custom key", 'dt_woocommerce_page_builder' ), 
				"param_name" => "product_custom_key", 
				'value' => '', 
				"description" =>esc_html__( "Enter custom key.", 'dt_woocommerce_page_builder' ) ), 
			array( 
				"type" => "textfield", 
				"heading" => esc_html__( 'Extra class name', 'js_composer' ), 
				"param_name" => "el_class", 
				'value' => '', 
				"description" => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'js_composer' ) ), 
			array( 
				'type' => 'css_editor', 
				'heading' => esc_html__( 'CSS box', 'js_composer' ), 
				'param_name' => 'css', 
				'group' => esc_html__( 'Design Options', 'js_composer' ) ) ) ) );