<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
/*********************************************************************************
 * The contents of this file are subject to the SugarCRM Enterprise Subscription
 * Agreement ("License") which can be viewed at
 * http://www.sugarcrm.com/crm/products/sugar-enterprise-eula.html
 * By installing or using this file, You have unconditionally agreed to the
 * terms and conditions of the License, and You may not use this file except in
 * compliance with the License.  Under the terms of the license, You shall not,
 * among other things: 1) sublicense, resell, rent, lease, redistribute, assign
 * or otherwise transfer Your rights to the Software, and 2) use the Software
 * for timesharing or service bureau purposes such as hosting the Software for
 * commercial gain and/or for the benefit of a third party.  Use of the Software
 * may be subject to applicable fees and any use of the Software without first
 * paying applicable fees is strictly prohibited.  You do not have the right to
 * remove SugarCRM copyrights from the source code or user interface.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *  (i) the "Powered by SugarCRM" logo and
 *  (ii) the SugarCRM copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * Your Warranty, Limitations of liability and Indemnity are expressly stated
 * in the License.  Please refer to the License for the specific language
 * governing these rights and limitations under the License.  Portions created
 * by SugarCRM are Copyright (C) 2004-2007 SugarCRM, Inc.; All Rights Reserved.
 ********************************************************************************/
/*********************************************************************************

 * Description:  Defines the English language pack for the base application.
 * Portions created by SugarCRM are Copyright (C) SugarCRM, Inc.
 * All Rights Reserved.
 * Contributors: Genius4U Ltd., simplicity GmbH, iscongroup kft.
 ********************************************************************************/

//the left value is the key stored in the db and the right value is ie display value
//to translate, only modify the right value in each key/value pair
$app_list_strings = array (
//e.g. auf Deutsch 'Contacts'=>'Kontakte',
  'language_pack_name' => 'Deutsch',
  'moduleList' =>
  array (
    'Home' => 'Home',
    'Dashboard' => 'Übersicht',
    'Contacts' => 'Kontakte',
    'Accounts' => 'Firmen',
    'Opportunities' => 'Verkaufschancen',
    'Cases' => 'Fälle',
    'Notes' => 'Notizen',
    'Calls' => 'Anrufe',
    'Emails' => 'E-Mails',
    'Meetings' => 'Meetings',
    'Tasks' => 'Aufgaben',
    'Calendar' => 'Kalender',
    'Leads' => 'Interessenten',

    'Contracts'=>'Verträge',
    'Quotes' => 'Angebote',
    'Products' => 'Produkte',
    'ProductCategories' => 'Produktkategorien',
    'ProductTypes' => 'Produktarten',
    'ProductTemplates' => 'Produktkatalog',
    'Reports' => 'Berichte',
    'Reports_1'=>'Berichte',
    'Forecasts' => 'Prognosen',
    'ForecastSchedule'=>'Prognoseplan',
    'MergeRecords'=>'Datensätze zusammenführen',
    'Quotas' => 'Vorgaben',
    'Teams' => 'Teams',

    'Activities' => 'Aktivitäten',
    'Bugs' => 'Fehlerverfolgung',
    'Feeds' => 'RSS',
    'iFrames'=>'Mein Portal',
    'TimePeriods'=>'Zeiträume',
    'Project'=>'Projekte',
    'ProjectTask'=>'Projektaufgaben',
    'Campaigns'=>'Kampagnen',
    'CampaignLog'=>'Kampagne Log',
    'Documents'=>'Dokumente',
    'Sync'=>'Sync',

    'ReportMaker' => ' SweetReports',


    'WorkFlow' => 'Workflow',

    'Users' => 'Benutzer',
    'Releases' => 'Releases',
    'Prospects' => 'Zielkontakte',
    'Queues' => 'Warteschlangen',
    'EmailMarketing' => 'E-Mail Marketing',
    'EmailTemplates' => 'E-Mail Vorlagen',
    'ProspectLists' => 'Kontaktlisten',
    'SavedSearch' => 'Gespeicherte Suche',
        ),
  'moduleListSingular' =>
  array (
    'Home' => 'Home',
    'Dashboard' => 'Übersicht',
    'Contacts' => 'Kontakt',
    'Accounts' => 'Firma',
    'Opportunities' => 'Verkaufschance',
    'Cases' => 'Fall',
    'Notes' => 'Notiz',
    'Calls' => 'Anruf',
    'Emails' => 'E-Mail',
    'Meetings' => 'Meeting',
    'Tasks' => 'Aufgabe',
    'Calendar' => 'Kalender',
    'Leads' => 'Interessent',

    'Quotes' => 'Angebot',
    'Products' => 'Produkt',
    'Reports' => 'Bericht',
    'Forecasts' => 'Prognose',
    'ForecastSchedule'=>'Prognoseplan',
    'Quotas' => 'Vorgabe',
    'Teams' => 'Team',

    'Activities' => 'Aktivitäten',
    'Bugs' => 'Fehlerverfolgung',
    'Feeds' => 'RSS',
    'iFrames'=>'Mein Portal',
    'TimePeriods'=>'Zeitraum',
    'Project'=>'Projekte',
    'ProjectTask'=>'Projektaufgabe',
    'Campaigns'=>'Kampagnen',
    'Documents'=>'Dokumente',
    'Sync'=>'Sync',

    'ReportMaker' => ' SweetReport',


    'WorkFlow' => 'Workflow',

    'Users' => 'Benutzer'
        ),

  'checkbox_dom'=> array(
    ''=>'',
    '1'=>'Ja',
    '2'=>'Nein',
  ),

  //e.g. en fran�ais 'Analyst'=>'Analyste',
  'account_type_dom' =>
  array (
    '' => '',
    'Analyst' => 'Analyst',
    'Competitor' => 'Mitbewerber',
    'Customer' => 'Kunde',
    'Integrator' => 'Integrator',
    'Investor' => 'Investor',
    'Partner' => 'Partner',
    'Press' => 'Presse',
    'Prospect' => 'Potentieller Kunde',
    'Reseller' => 'Wiederverkäufer',
    'Other' => 'Andere',
  ),
  //e.g. en espa�ol 'Apparel'=>'Ropa',
  'industry_dom' =>
  array (
    '' => '',
    'Apparel' => 'Bekleidungsindustrie',
    'Banking' => 'Bankwesen',
    'Biotechnology' => 'Biotechnologie',
    'Chemicals' => 'Chemieindustrie',
    'Communications' => 'Kommunikation',
    'Construction' => 'Baugewerbe',
    'Consulting' => 'Beratung',
    'Education' => 'Bildungwesen',
    'Electronics' => 'Elektronik',
    'Energy' => 'Energieerzeuger',
    'Engineering' => 'Entwicklung',
    'Entertainment' => 'Unterhaltungsindustrie',
    'Environmental' => 'Umwelt',
    'Finance' => 'Finanzsektor',
    'Government' => 'Öffentliche Einrichtung',
    'Healthcare' => 'Gesundheitswesen',
    'Hospitality' => 'Gastgewerbe',
    'Insurance' => 'Versicherung',
    'Machinery' => 'Maschinenbau',
    'Manufacturing' => 'Produktion',
    'Media' => 'Medien',
    'Not For Profit' => 'Gemeinnützige Organisation',
    'Recreation' => 'Freizeitindustrie',
    'Retail' => 'Einzelhandel',
    'Shipping' => 'Versandhandel',
    'Technology' => 'Technologie',
    'Telecommunications' => 'Telekommunikation',
    'Transportation' => 'Transportwesen',
    'Utilities' => 'Energieversorger',
    'Other' => 'Andere',
  ),
  'source_default_key' => 'Self Generated',
  'lead_source_dom' =>
  array (
    '' => '',
    'Cold Call' => 'Kalt Akquise',
    'Existing Customer' => 'Bestehender Kunde',
    'Self Generated' => 'Selbst generierter Kunde',
    'Employee' => 'Mitarbeiter',
    'Partner' => 'Partner',
    'Public Relations' => 'Public Relations',
    'Direct Mail' => 'Aussendung',
    'Conference' => 'Konferenz',
    'Trade Show' => 'Messe',
    'Web Site' => 'Web Seite',
    'Word of mouth' => 'Mund zu Mund Propaganda',
    'Email' => 'E-Mail',
    'Campaign'=>'Kampagne',
    'Other' => 'Andere',
  ),
  'opportunity_type_dom' =>
  array (
    '' => '',
    'Existing Business' => 'Bestehendes Geschäft',
    'New Business' => 'Neues Geschäft',
  ),
  'roi_type_dom' =>
    array (
    'Revenue' => 'Umsatz',
    'Investment'=>'Investition',
    'Expected_Revenue'=>'Erwarteter Umsatz',
    'Budget'=>'Budget',

  ),
  //Note:  do not translate opportunity_relationship_type_default_key
//       it is the key for the default opportunity_relationship_type_dom value
  'opportunity_relationship_type_default_key' => 'Primary Decision Maker',
  'opportunity_relationship_type_dom' =>
  array (
    '' => '',
    'Primary Decision Maker' => 'Hauptentscheidungsträger',
    'Business Decision Maker' => 'Business Entscheidungsträger',
    'Business Evaluator' => 'Business Vorentscheider',
    'Technical Decision Maker' => 'Technischer Entscheidungsträger',
    'Technical Evaluator' => 'Technik Vorentscheider',
    'Executive Sponsor' => 'Executive Sponsor',
    'Influencer' => 'Einflussreiche Person',
    'Other' => 'Andere',
  ),
  //Note:  do not translate case_relationship_type_default_key
//       it is the key for the default case_relationship_type_dom value
  'case_relationship_type_default_key' => 'Primary Contact',
  'case_relationship_type_dom' =>
  array (
    '' => '',
    'Primary Contact' => 'Hauptkontakt',
    'Alternate Contact' => 'Zweitkontakt',
  ),
  'payment_terms' =>
  array (
    '' => '',
    'Net 15' => '14 Tage netto',
    'Net 30' => '30 Tage netto',
  ),
  'sales_stage_default_key' => 'Prospecting',
  'sales_stage_dom' =>
  array (
    'Prospecting' => 'Prospecting',
    'Qualification' => 'Qualifikation',
    'Needs Analysis' => 'Bedarfserhebung',
    'Value Proposition' => 'Richtangebot',
    'Id. Decision Makers' => 'Entscheider ident.',
    'Perception Analysis' => 'Analyse Sichtweise',
    'Proposal/Price Quote' => 'Preisangebot',
    'Negotiation/Review' => 'Verhandlung/Überarbeitung',
    'Closed Won' => 'Gewonnen',
    'Closed Lost' => 'Verloren',
  ),
  'sales_probability_dom' => // keys must be the same as sales_stage_dom
  array (
    'Prospecting' => '10',
    'Qualification' => '20',
    'Needs Analysis' => '25',
    'Value Proposition' => '30',
    'Id. Decision Makers' => '40',
    'Perception Analysis' => '50',
    'Proposal/Price Quote' => '65',
    'Negotiation/Review' => '80',
    'Closed Won' => '100',
    'Closed Lost' => '0',
  ),
  'activity_dom' =>
  array (
    'Call' => 'Anruf',
    'Meeting' => 'Meeting',
    'Task' => 'Aufgabe',
    'Email' => 'E-Mail',
    'Note' => 'Notiz',
  ),
  'salutation_dom' =>
      array (
        '' => '',
        'Mr.' => 'Hr.',
        'Ms.' => 'Fr.',
        'Mrs.' => 'Fr.',
        'Dr.' => 'Dr.',
        'Prof.' => 'Prof.',
      ),
  //time is in seconds; the greater the time the longer it takes;
  'reminder_max_time'=>3600,
  'reminder_time_options' => array( 60=> '1 min. vorher',
                                  300=> '5 min. vorher',
                                  600=> '10 min. vorher',
                                  900=> '15 min. vorher',
                                  1800=> '30 min. vorher',
                                  3600=> '1 h vorher',
                                 ),

  'task_priority_default' => 'Medium',
  'task_priority_dom' =>
  array (
    'High' => 'Hoch',
    'Medium' => 'Mittel',
    'Low' => 'Niedrig',
  ),
  'task_status_default' => 'Not Started',
  'task_status_dom' =>
  array (
    'Not Started' => 'Nicht begonnen',
    'In Progress' => 'In Bearbeitung',
    'Completed' => 'Abgeschlossen',
    'Pending Input' => 'Rückmeldung ausstehend',
    'Deferred' => 'Zurückgestellt',
  ),
  'meeting_status_default' => 'Planned',
  'meeting_status_dom' =>
  array (
    'Planned' => 'Geplant',
    'Held' => 'Durchgeführt',
    'Not Held' => 'Nicht durchgeführt',
  ),
  'call_status_default' => 'Planned',
  'call_status_dom' =>
  array (
    'Planned' => 'Geplant',
    'Held' => 'Durchgeführt',
    'Not Held' => 'Nicht durchgeführt',
  ),
  'call_direction_default' => 'Outbound',
  'call_direction_dom' =>
  array (
    'Inbound' => 'Eingehend',
    'Outbound' => 'Ausgehend',
  ),
  'lead_status_dom' =>
  array (
    '' => '',
    'New' => 'Neu',
    'Assigned' => 'Zugewiesen',
    'In Process' => 'In Arbeit',
    'Converted' => 'Umgewandelt',
    'Recycled' => 'Wiedereröffnet',
    'Dead' => '\'Gestorben\'',
  ),
   'gender_list' =>
  array (
    'male' => 'Männlich',
    'female' => 'Weiblich',
  ),
  //Note:  do not translate case_status_default_key
//       it is the key for the default case_status_dom value
  'case_status_default_key' => 'New',
  'case_status_dom' =>
  array (
    'New' => 'Neu',
    'Assigned' => 'Zugewiesen',
    'Closed' => 'Abgeschlossen',
    'Pending Input' => 'Rückmeldung ausstehend',
    'Rejected' => 'Abgelehnt',
    'Duplicate' => 'Duplizieren',
  ),
  'case_priority_default_key' => 'P2',
  'case_priority_dom' =>
  array (
    'P1' => 'Hoch',
    'P2' => 'Mittel',
    'P3' => 'Niedrig',
  ),
  'user_status_dom' =>
  array (
    'Active' => 'Aktiv',
    'Inactive' => 'Inaktiv',
  ),
  'employee_status_dom' =>
  array (
    'Active' => 'Aktiv',
    'Terminated' => 'Beendet',
    'Leave of Absence' => 'Abwesend',
  ),
  'messenger_type_dom' =>
  array (
    '' => '',
    'MSN' => 'MSN',
    'Yahoo!' => 'Yahoo!',
    'AOL' => 'AOL',
  ),

    'project_task_priority_options' => array (
        'High' => 'Hoch',
        'Medium' => 'Mittel',
        'Low' => 'Niedrig',
    ),
    'project_task_priority_default' => 'Medium',

    'project_task_status_options' => array (
        'Not Started' => 'Nicht begonnen',
        'In Progress' => 'In Bearbeitung',
        'Completed' => 'Abgeschlossen',
        'Pending Input' => 'Rückmeldung ausstehend',
        'Deferred' => 'Zurückgestellt',
    ),
    'project_task_utilization_options' => array (
        '0' => 'Keine Einträge vorhanden',
        '25' => '25',
        '50' => '50',
        '75' => '75',
        '100' => '100',
    ),

    'project_status_dom' => array (
        'Draft' => 'Entwurf',
        'In Review' => 'In Durchsicht',
        'Published' => 'Veröffentlicht',
    ),
    'project_status_default' => 'Draft',

    'project_duration_units_dom' => array (
        'Days' => 'Tage',
        'Hours' => 'Stunden',
    ),

    'project_priority_options' => array (
        'High' => 'Hoch',
        'Medium' => 'Mittel',
        'Low' => 'Niedrig',
    ),
    'project_priority_default' => 'Mittel',

  //Note:  do not translate record_type_default_key
//       it is the key for the default record_type_module value
  'record_type_default_key' => 'Accounts',
  'record_type_display' =>
  array (
    '' => '',
    'Accounts' => 'Firma',
    'Opportunities' => 'Verkaufschance',
    'Cases' => 'Fall',
    'Leads' => 'Interessent',
    'Contacts' => 'Kontakte', // cn (11/22/2005) added to support Emails

    'ProductTemplates' => 'Produkt',
    'Quotes' => 'Angebot',

    'Bugs' => 'Fehler',
    'Project' => 'Projekt',



    'ProjectTask' => 'Projektaufgabe',
    'Tasks' => 'Aufgabe',
    'Prospects' => 'Zielkontakt',
  ),

  'record_type_display_notes' =>
  array (
    'Accounts' => 'Firma',
    'Contacts' => 'Kontakt',
    'Opportunities' => 'Verkaufschance',
    'Cases' => 'Fall',
    'Leads' => 'Interessent',

    'ProductTemplates' => 'Produkt',
    'Quotes' => 'Angebot',
    'Products' => 'Produkt',
    'Contracts' => 'Vertrag',

    'Bugs' => 'Fehler',
    'Emails' => 'E-Mail',
    'Project' => 'Projekt',
    'ProjectTask' => 'Projektaufgabe',
    'Meetings' => 'Meeting',
    'Calls' => 'Anruf'
  ),

  'parent_type_display' =>
  array (
    'Accounts' => 'Firma',
    'Bugs' => 'Fehlerverfolgung',
    'Cases' => 'Fall',
    'Contacts' => 'Kontakt',
    'Leads' => 'Interessent',
    'Opportunities' => 'Verkaufschance',

    'Products' => 'Produkt',

    'Project' => 'Projekt',
    'ProjectTask' => 'Projektaufgabe',
    'Prospects' => 'Potentieller Kunde',

    'Quotes' => 'Angebot',

    'Tasks' => 'Aufgabe',
  ),


  'product_status_default_key' => 'Ship',
  'product_status_quote_key' => 'Quotes',
  'product_status_dom' =>
  array (
    'Quotes' => 'Angeboten',
    'Orders' => 'Bestellt',
    'Ship' => 'Geliefert',
  ),


  'pricing_formula_default_key' => 'Fixed',
  'pricing_formula_dom' =>
  array (
    'Fixed' => 'Fixpreis',
    'ProfitMargin' => 'Gewinnspanne',
    'PercentageMarkup' => 'Gewinnaufschlag',
    'PercentageDiscount' => 'Rabatt vom Listenpreis',
    'IsList' => 'Gleich wie Liste',
  ),
  'product_template_status_dom' =>
  array (
    'Available' => 'Auf Lager',
    'Unavailable' => 'Nicht lagernd',
  ),
  'tax_class_dom' =>
  array (
    'Taxable' => 'Steuerpflichtig',
    'Non-Taxable' => 'Nicht steuerpflichtig',
  ),
  'support_term_dom' =>
  array (
    '+6 months' => 'Sechs Monate',
    '+1 year' => 'Ein Jahr',
    '+2 years' => 'Zwei Jahre',
  ),


  'quote_type_dom' =>
  array (
    'Quotes' => 'Angebot',
    'Orders' => 'Position',
  ),
  'default_quote_stage_key' => 'Draft',
  'quote_stage_dom' =>
  array (
    'Draft' => 'Entwurf',
    'Negotiation' => 'Verhandlung',
    'Delivered' => 'Geliefert',
    'On Hold' => 'Abwarten',
    'Confirmed' => 'Bestätigt',
    'Closed Accepted' => 'Gewonnen',
    'Closed Lost' => 'Verloren',
    'Closed Dead' => 'Wird nicht realisiert',
  ),
  'default_order_stage_key' => 'Pending',
  'order_stage_dom' =>
  array (
    'Pending' => 'Pending',
    'Confirmed' => 'Bestätigt',
    'On Hold' => 'Abwarten',
    'Shipped' => 'Geliefert',
    'Cancelled' => 'Storniert',
  ),

//Note:  do not translate quote_relationship_type_default_key
//       it is the key for the default quote_relationship_type_dom value
  'quote_relationship_type_default_key' => 'Primary Decision Maker',
  'quote_relationship_type_dom' =>
  array (
    '' => '',
    'Primary Decision Maker' => 'Hauptentscheidungsträger',
    'Business Decision Maker' => 'Business Entscheidungsträger',
    'Business Evaluator' => 'Business Vorentscheider',
    'Technical Decision Maker' => 'Technischer Entscheidungsträger',
    'Technical Evaluator' => 'Technik Vorentscheider',
    'Executive Sponsor' => 'Executive Sponsor',
    'Influencer' => 'Einflussreiche Person',
    'Other' => 'Andere',
  ),
  'layouts_dom' =>
  array (
    'Standard' => 'Angebot',
    'Invoice' => 'Rechnung',
    'Terms' => 'Zahlungskonditionen'
  ),

  'issue_priority_default_key' => 'Medium',
  'issue_priority_dom' =>
  array (
    'Urgent' => 'Dringend',
    'High' => 'Hoch',
    'Medium' => 'Mittel',
    'Low' => 'Niedrig',
  ),
  'issue_resolution_default_key' => '',
  'issue_resolution_dom' =>
  array (
    '' => '',
    'Accepted' => 'Akzeptiert',
    'Duplicate' => 'Duplizieren',
    'Closed' => 'Abgeschlossen',
    'Out of Date' => 'Abgelaufen',
    'Invalid' => 'Ungültig',
  ),

  'issue_status_default_key' => 'New',
  'issue_status_dom' =>
  array (
    'New' => 'Neu',
    'Assigned' => 'Zugewiesen',
    'Closed' => 'Abgeschlossen',
    'Pending' => 'Pending',
    'Rejected' => 'Abgelehnt',
  ),

  'bug_priority_default_key' => 'Medium',
  'bug_priority_dom' =>
  array (
    'Urgent' => 'Dringend',
    'High' => 'Hoch',
    'Medium' => 'Mittel',
    'Low' => 'Niedrig',
  ),
   'bug_resolution_default_key' => '',
  'bug_resolution_dom' =>
  array (
    '' => '',
    'Accepted' => 'Akzeptiert',
    'Duplicate' => 'Duplizieren',
    'Fixed' => 'Fixed',
    'Out of Date' => 'Abgelaufen',
    'Invalid' => 'Ungültig',
    'Later' => 'Später',
  ),
  'bug_status_default_key' => 'New',
  'bug_status_dom' =>
  array (
    'New' => 'Neu',
    'Assigned' => 'Zugewiesen',
    'Closed' => 'Abgeschlossen',
    'Pending' => 'Pending',
    'Rejected' => 'Abgelehnt',
  ),
   'bug_type_default_key' => 'Defect',
  'bug_type_dom' =>
  array (
    'Defect' => 'Defekt',
    'Feature' => 'Eigenschaft',
  ),
 'case_type_dom' =>
  array (
    'Administration' => 'Administration',
    'Product' => 'Produkt',
    'User' => 'Benutzer',
  ),

  'source_default_key' => '',
  'source_dom' =>
  array (
    '' => '',
    'Internal' => 'Intern',
    'Forum' => 'Forum',
    'Web' => 'Web',
    'InboundEmail' => 'E-Mail'
  ),

  'product_category_default_key' => '',
  'product_category_dom' =>
  array (
    '' => '',
    'Accounts' => 'Firmen',
    'Activities' => 'Aktivitäten',
    'Bug Tracker' => 'Fehlerverfolgung',
    'Calendar' => 'Kalender',
    'Calls' => 'Anrufe',
    'Campaigns' => 'Kampagnen',
    'Cases' => 'Fälle',
    'Contacts' => 'Kontakte',
    'Currencies' => 'Währungen',
    'Dashboard' => 'Übersicht',
    'Documents' => 'Dokumente',
    'Emails' => 'E-Mails',
    'Feeds' => 'Feeds',
    'Forecasts' => 'Prognosen',
    'Help' => 'Hilfe',
    'Home' => 'Home',
    'Leads' => 'Interessenten',
    'Meetings' => 'Meetings',
    'Notes' => 'Notizen',
    'Opportunities' => 'Verkaufschancen',
    'Outlook Plugin' => 'Outlook Plugin',
    'Product Catalog' => 'Produktkatalog',
    'Products' => 'Produkte',
    'Projects' => 'Projekte',
    'Quotes' => 'Angebote',
    'Releases' => 'Releases',
    'RSS' => 'RSS',
    'Studio' => 'Studio',
    'Upgrade' => 'Upgrade',
    'Users' => 'Benutzer',
  ),

  /*Added entries 'Queued' and 'Sending' for 4.0 release..*/
  'campaign_status_dom' =>
  array (
        '' => '',
        'Planning' => 'Planung',
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        'Complete' => 'Fertig',
        'In Queue' => 'in Warteschlange',
        'Sending'=> 'wird gesendet',
  ),
  'campaign_type_dom' =>
  array (
        '' => '',
        'Telesales' => 'Telefonverkauf',
        'Mail' => 'Mail',
        'Email' => 'E-Mail',
        'Print' => 'Drucken',
        'Web' => 'Web',
        'Radio' => 'Radio',
        'Television' => 'Fernsehen',
        'NewsLetter' => 'Newsletter',
        ),

  'newsletter_frequency_dom' =>
  array (
        '' => '',
        'Weekly' => 'Wöchentlich',
        'Monthly' => 'Monatlich',
        'Quarterly' => 'alle 3 Monate',
        'Annually' => 'Jährlich',
        ),


  'notifymail_sendtype' =>
  array (
    'sendmail' => 'sendmail',
    'SMTP' => 'SMTP',
  ),
  'dom_timezones' => array('-12'=>'(GMT - 12) Internationale Datumsgrenze West',
                            '-11'=>'(GMT - 11) Midway Inseln, Samoa',
                            '-10'=>'(GMT - 10) Hawaii',
                            '-9'=>'(GMT - 9) Alaska',
                            '-8'=>'(GMT - 8) San Francisco',
                            '-7'=>'(GMT - 7) Phoenix',
                            '-6'=>'(GMT - 6) Saskatchewan',
                            '-5'=>'(GMT - 5) New York',
                            '-4'=>'(GMT - 4) Santiago',
                            '-3'=>'(GMT - 3) Buenos Aires',
                            '-2'=>'(GMT - 2) Mid-Atlantic',
                            '-1'=>'(GMT - 1) Azoren',
                            '0'=>'(GMT)',
                            '1'=>'(GMT + 1) Madrid',
                            '2'=>'(GMT + 2) Athen',
                            '3'=>'(GMT + 3) Moskau',
                            '4'=>'(GMT + 4) Kabul',
                            '5'=>'(GMT + 5) Jekaterinenburg',
                            '6'=>'(GMT + 6) Astana',
                            '7'=>'(GMT + 7) Bangkok',
                            '8'=>'(GMT + 8) Perth',
                            '9'=>'(GMT + 9) Seoul',
                            '10'=>'(GMT + 10) Brisbane',
                            '11'=>'(GMT + 11) Solomonen Inseln',
                            '12'=>'(GMT + 12) Auckland',
                            ),
      'dom_cal_month_long'=>array(
                '0'=>"",
                '1'=>"Januar",
                '2'=>"Februar",
                '3'=>"März",
                '4'=>"April",
                '5'=>"Mai",
                '6'=>"Juni",
                '7'=>"Juli",
                '8'=>"August",
                '9'=>"September",
                '10'=>"Oktober",
                '11'=>"November",
                '12'=>"Dezember",
        ),
    'dom_meridiem_lowercase'=>array(
                'am'=>"am",
                'pm'=>"pm"
        ),
    'dom_meridiem_uppercase'=>array(
                 'AM'=>'AM',
                 'PM'=>'PM'
        ),
    'dom_report_types'=>array(
                'tabular'=>'Zeilen und Spalten',
                'summary'=>'Summierung',
                'detailed_summary'=>'Summe mit Details',
        ),
    'dom_email_types'=> array(
        'out'       => 'Gesendet',
        'archived'  => 'Archiviert',
        'draft'     => 'Entwurf',
        'inbound'   => 'Eingehend',
        'campaign'  => 'Kampagne'
    ),
    'dom_email_status' => array (
        'archived'  => 'Archiviert',
        'closed'    => 'Abgeschlossen',
        'draft'     => 'Entwurf',
        'read'      => 'Gelesen',
        'replied'   => 'Beantwortet',
        'sent'      => 'Gesendet',
        'send_error'=> 'Sende-Fehler',
        'unread'    => 'Ungelesen',
    ),
    'dom_email_archived_status' => array (
        'archived'  => 'Archiviert',
    ),

    'dom_email_server_type' => array(   ''          => '--Kein(e)--',
                                        'imap'      => 'IMAP',
                                        'pop3'      => 'POP3',
    ),
    'dom_mailbox_type'      => array(/*''           => '--None Specified--',*/
                                     'pick'     => 'Neuer Vorgang/Interessent/Kontakt/Fehler',
                                     'bug'      => 'Neuer Fehler',
                                     'support'  => 'Neuer Fall',
                                     'contact'  => 'Neuer Kontakt',
                                     'sales'    => 'Neuer Interessent',
                                     'task'     => 'Neue Aufgabe',
                                     'bounce'   => 'Nicht zustellbare bearbeiten',
    ),
    'dom_email_distribution'=> array(''             => '--Kein(e)--',
                                     'direct'       => 'Direkt zuweisen',
                                     'roundRobin'   => 'Umlauf-Verfahren',
                                     'leastBusy'    => 'geringste Auslastung',
    ),
    'dom_email_errors'      => array(1 => 'Beim direkt Zuweisen nur 1 Mitarbeiter auswählen.',
                                     2 => 'Beim direkt Zuweisen müssen die markierten zugewiesen werden.',
    ),
    'dom_email_bool'        => array('bool_true' => 'Ja',
                                     'bool_false' => 'Nein',
    ),
    'dom_int_bool'          => array(1 => 'Ja',
                                     0 => 'Nein',
    ),
    'dom_switch_bool'       => array ('on' => 'Ja',
                                        'off' => 'Nein',
                                        '' => 'Nein', ),
    'dom_email_link_type'   => array(   ''          => 'Standard E-Mail Client',
                                        'sugar'     => 'SugarCRM E-Mail Client',
                                        'mailto'    => 'Externer Mail Client'),

    'dom_email_editor_option'=> array(  ''          => 'Standard E-Mail Format',
                                        'html'      => 'HTML E-Mail',
                                        'plain'     => 'Plain Text Email'),


    'schedulers_times_dom'  => array(   'not run'       => 'Zeitvorgabe abgelaufen, nicht ausgeführt',
                                        'ready'         => 'Bereit',
                                        'in progress'   => 'In Bearbeitung',
                                        'failed'        => 'Fehlgeschlagen',
                                        'completed'     => 'Abgeschlossen',
                                        'no curl'       => 'Nicht gelaufen: cURL nicht verfügbar',
    ),

    'scheduler_status_dom' =>
        array (
        'Active' => 'Aktiv',
        'Inactive' => 'Inaktiv',
        ),

    'scheduler_period_dom' =>
        array (
        'min' => 'Minuten',
        'hour' => 'Stunden',
        ),

    'forecast_schedule_status_dom' =>
    array (
    'Active' => 'Aktiv',
    'Inactive' => 'Inaktiv',
  ),
    'forecast_type_dom' =>
    array (
    'Direct' => 'Direkt',
    'Rollup' => 'Rollup',
  ),

    'document_category_dom' =>
    array (
    '' => '',
    'Marketing' => 'Marketing',
    'Knowledege Base' => 'Wissensbasis',
    'Sales' => 'Verkauf',
  ),

    'document_subcategory_dom' =>
    array (
    '' => '',
    'Marketing Collateral' => 'Werbematerial',
    'Product Brochures' => 'Produktbroschüren',
    'FAQ' => 'FAQ',
  ),

    'document_status_dom' =>
    array (
    'Active' => 'Aktiv',
    'Draft' => 'Entwurf',
    'FAQ' => 'FAQ',
    'Expired' => 'Abgelaufen',
    'Under Review' => 'Wird überprüft',
    'Pending' => 'Pending',
  ),
  'document_template_type_dom' =>
  array(
    ''=>'',
    'mailmerge'=>'Serienbrief',
    'eula'=>'EULA',
    'nda'=>'NDA',
    'license'=>'Lizenz Vereinbarung',
  ),
    'dom_meeting_accept_options' =>
    array (
    'accept' => 'Bestätigen',
    'decline' => 'Ablehnen',
    'tentative' => 'Vorläufig',
  ),
    'dom_meeting_accept_status' =>
    array (
    'accept' => 'Akzeptiert',
    'decline' => 'Abgelehnt',
    'tentative' => 'Vorläufig',
    'none'      => 'Kein(e)',
  ),

        'dataset_output_default_dom' =>
    array (
    'table' => 'Tabelle',
  ),
    'report_maker_status_dom' =>
    array (
    'Single Module' => 'Einzelmodul',
    'Multi Module' => 'Mehrfachmodul',
  ),
  'report_align_dom' =>
    array (
    'left' => 'Links',
    'center' => 'Mitte',
    'right' => 'Rechts',
  ),

    'width_type_dom' =>
    array (
    '%' => 'Prozent (%)',
    'px' => 'Pixel (px)',
  ),
    'report_color_dom' =>
    array (
    '' => 'Standard',
    'black' => 'Schwarz',
    'green' => 'Grün',
    'blue' => 'Blau',
    'red' => 'Rot',
    'white' => 'Weiß',
    'DarkGreen' => 'Dunkelgrün',
    'LightGray' => 'Blassgrau',
    'DodgerBlue' => 'Mittelblau',
    'LightBlue' => 'Hellblau',
  ),
    'font_size_dom' =>
    array (
    '-5' => 'Kleiner (-5)',
    '-4' => 'Kleiner (-4)',
    '-3' => 'Kleiner (-3)',
    '-2' => 'Kleiner (-2)',
    '-1' => 'Kleiner (-1)',
    'Default' => 'Standard',
    '1' => 'Größer (+1)',
    '2' => 'Größer (+2)',
    '3' => 'Größer (+3)',
    '4' => 'Größer (+4)',
    '5' => 'Größer (+5)',
  ),
        'query_type_dom' =>
    array (
    'Main Query' => 'Hauptabfrage',
//  'Sub Query' => 'Unterabfrage',
//  'Reverse Sub Query' => 'Umgekehrte Unterabfrage',
  ),
        'query_column_type_dom' =>
    array (
    'Display' => 'Anzeige',
//  'Group By' => 'Gruppieren nach',
    'Calculation' => 'Berechnung',
  ),
        'query_display_type_dom' =>
    array (
    'Default' => 'Standard',
    'Custom' => 'Benutzerdefiniert',
    'Hidden' => 'Verborgen',
  ),

            'query_groupby_qualifier_dom' =>
    array (
    'Day' => 'Tag',
    'Week' => 'Woche',
    'Month' => 'Monat',
    'Quarter' => 'Quartal',
    'Year' => 'Jahr',
  ),

            'query_groupby_qualifier_qty_dom' =>
    array (
    '1' => '1',
    '2' => '2',
    '3' => '3',
    '4' => '4',
    '5' => '5',
    '6' => '6',
    '7' => '7',
    '8' => '8',
    '9' => '9',
    '10' => '10',
    '12' => '12',
    '18' => '18',
    '24' => '24',
  ),

            'query_groupby_qualifier_start_dom' =>
    array (
    '0' => 'Jetzt',
    '-1' => '-1',
    '-2' => '-2',
    '-3' => '-3',
    '-4' => '-4',
    '-5' => '-5',
    '-6' => '-6',
    '-7' => '-7',
    '-8' => '-8',
    '-9' => '-9',
    '-10' => '-10',
    '12' => '-12',
    '-18' => '-18',
    '-24' => '-24',
  ),
            'query_groupby_calc_type_dom' =>
    array (
    'SUM' => 'SUM',
    'AVG' => 'AVG',
    'COUNT' => 'Zähler',
    'STDDEV' => 'Standard Abweichung',
    'VARIANCE' => 'Varianz',
//  'Custom' => 'Benutzerdefiniert',
  ),
            'query_groupby_type_dom' =>
    array (
    'Field' => 'Standard Feld',
    'Time' => 'Zeitababstand',
//  'Custom' => 'Selbstdefiniertes Gruppieren nach',
  ),

  'query_groupby_axis_dom' =>
    array (
    'Rows' => 'Zeilen (Y-Achse)',
    'Columns' => 'Spalten (X-Achse)',
  ),

  'query_calc_calc_type_dom' =>
    array (
    'SUM' => 'Summe (Gesamt)',
    'AVG' => 'Durchschnitt',
    'MAX' => 'Maximum',
    'MIN' => 'Minimum',
    'COUNT' => 'Zähler',
    'STDDEV' => 'Standard Abweichung',
    'VARIANCE' => 'Varianz',
  ),
  'query_calc_type_dom' =>
    array (
    'Standard' => 'Standard',
//  'Sub-Query' => 'Unterabfrage',
    'Math' => 'Math Calc',
  ),

  'query_calc_oper_dom' =>
      array (
    '+' => '(+) Plus',
    '-' => '(-) Minus',
    '*' => '(X) Multipliziert Mit',
    '/' => '(/) Geteilt Durch',
  ),

    'query_calc_leftright_type_dom' =>
      array (
    'Field' => 'Feld',
    'Value' => 'Wert',
    'Group' => 'Gruppe',
  ),


  'dataset_layout_type_dom' =>
      array (
    'Column' => 'Spalte',
    //'Row' => 'Zeile',
  ),

  'custom_layout_dom' =>
         array (
    'Disabled' => 'Inaktiv',
    'Enabled' => 'Aktiv',
  ),
    'dataset_att_display_type_dom' =>
      array (
     'Normal' => 'Normal',
    'Scalar' => 'Skalar',
  ),
  'dataset_att_format_type_dom' =>
        array (
    'Text' => 'Text',
    'Accounting' => 'Buchhaltung',
    'Date' => 'Datum',
    'Datetime' => 'Datum/Zeit',
  ),
    'dataset_att_format_type_scalar_dom' =>
        array (
    'Year' => 'Jahr',
    'Quarter' => 'Quartal',
    'Month' => 'Monat',
    'Week' => 'Woche',
    'Day' => 'Tag',
  ),
  'dataset_style_dom' =>
        array (
    'normal' => 'Normal',
    'bold' => 'Fett',
    'italic' => 'Kursiv',
  ),


  'query_calc_oper_dom' =>
      array (
    '+' => '(+) Plus',
    '-' => '(-) Minus',
    '*' => '(X) Multipliziert Mit',
    '/' => '(/) Geteilt Durch',
  ),
  'wflow_type_dom' =>
        array (
    'Normal' => 'Beim Speichern',
    'Time' => 'Nach Zeitablauf',
  ),
  'mselect_type_dom' =>
        array (
    'Equals' => 'Ist',
    'in' => 'Ist eines(r) von',
  ),
  'mselect_multi_type_dom' =>
        array (
    'in' => 'Ist eines(r) von',
    'not_in' => 'Ist keines(r) von',
  ),
   'cselect_type_dom' =>
        array (
    'Equals' => 'Gleich',
    'Does not Equal' => 'Ungleich',
  ),
   'dselect_type_dom' =>
        array (
    'Equals' => 'Gleich',
    'Less Than' => 'Weniger als',
    'More Than' => 'Mehr als',
    'Does not Equal' => 'Ungleich',
  ),
   'bselect_type_dom' =>
        array (
    'bool_true' => 'Ja',
    'bool_false' => 'Nein',
  ),
    'bopselect_type_dom' =>
        array (
    'Equals' => 'Gleich',
  ),
    'tselect_type_dom' =>
        array (
    '0'     =>  '0 Stunden',
    '14440' => '4 Stunden',
    '28800' => '8 Stunden',
    '43200' => '12 Stunden',
    '86400' => '1 Tag',
    '172800' => '2 Tage',
    '259200' => '3 Tage',
    '345600' => '4 Tage',
    '432000' => '5 Tage',
    '604800' => '1 Woche',
    '1209600' => '2 Wochen',
    '1814400' => '3 Wochen',
    '2592000' => '30 Tage',
    '5184000' => '60 Tage',
    '7776000' => '90 Tage',
    '10368000' => '120 Tage',
    '12960000' => '150 Tage',
    '15552000' => '180 Tage',
  ),
      'dtselect_type_dom' =>
        array (
    'More Than' => 'war mehr als',
    'Less Than' => 'ist weniger als',
  ),
        'wflow_alert_type_dom' =>
        array (
    'Email' => 'E-Mail',
    'Invite' => 'Einladen',
  ),
        'wflow_source_type_dom' =>
        array (
    'Normal Message' => 'Normale Nachricht',
    'Custom Template' => 'Benutzerdefinierte Vorlage',
    'System Default' => 'System Vorgabe',
  ),
          'wflow_user_type_dom' =>
        array (
    'current_user' => 'Aktuelle Benutzer',
    'rel_user' => 'Verknüpfter Benutzer',
    'rel_user_custom' => 'Verknüpfter spezieller Benutzer',
    'specific_team' => 'Bestimmtes Team',
    'specific_role' => 'Bestimmte Rolle',
    'specific_user' => 'Bestimmter Benutzer',
  ),
          'wflow_array_type_dom' =>
        array (
    'future' => 'Neuer Wert',
    'past' => 'Alter Wert',
  ),
          'wflow_relate_type_dom' =>
        array (
    'Self' => 'Benutzer',
    'Manager' => "Benutzer Manager",
  ),
    'wflow_address_type_dom' =>
        array (
    'to' => 'An:',
    'cc' => 'Cc:',
    'bcc' => 'Bcc:',
  ),
     'wflow_address_type_invite_dom' =>
        array (
    'to' => 'An:',
    'cc' => 'Cc:',
    'bcc' => 'Bcc:',
    'invite_only' => '(Nur einladen)',
  ),
     'wflow_address_type_to_only_dom' =>
        array (
    'to' => 'An:',
  ),
    'wflow_action_type_dom' =>
        array (
    'update' => 'Eintrag aktualisieren',
    'update_rel' => 'Verknüpften Eintrag aktualisieren',
    'new' => 'Neuer Eintrag',
  ),
  'wflow_action_datetime_type_dom' =>
        array (
    'Triggered Date' => 'Getriggertes Datum',
    'Existing Value' => 'Bestehender Wert',
  ),
  'wflow_set_type_dom' =>
        array (
    'Basic' => 'Basisoptionen',
    'Advanced' => 'Erw. Optionen',
  ),
  'wflow_adv_user_type_dom' =>
        array (
    'assigned_user_id' => 'Benutzer zu getriggertem Eintrag zugewiesen',
    'modified_user_id' => 'Benutzer, der den getriggerten Eintrag zuletzt geändert hat',
    'created_by' => 'Benutzer, der den getriggerten Eintrag erstellt hat',
    'current_user' => 'Angemeldeter Benutzer',
  ),
  'wflow_adv_team_type_dom' =>
        array (
    'team_id' => 'Derzeitiges Team der getriggerten Einträge',
    'current_team' => 'Team von angemeldeten Benutzern',
  ),
  'wflow_adv_enum_type_dom' =>
        array (
    'retreat' => 'Auswahlfeld zurückbewegen um',
    'advance' => 'Auswahlfeld nach vorne bewegen um',
  ),
  'wflow_record_type_dom' =>
        array (
    'All' => 'Neue und bestehende Einträge',
    'New' => 'Nur neue Einträge',
    'Update' => 'Nur bestehende Einträge',
  ),
  'wflow_rel_type_dom' =>
        array (
    'all' => 'Alle verknüpften',
    //'first' => 'Der erste verknüpfte',
    'filter' => 'Verknüpfte filtern',
        ),
  'wflow_relfilter_type_dom' =>
        array (
    'all' => 'alle verknüpften',
    'any' => 'jeden verknüpften',
        ),
    //I added the PST, CST, MST, EST denotations here
  'dom_timezones_extra' => array('-12'=>'(GMT - 12) Internationale Datumsgrenze West',
                            '-11'=>'(GMT - 11) Midway Inseln, Samoa',
                            '-10'=>'(GMT - 10) Hawaii',
                            '-9'=>'(GMT - 9) Alaska',
                            '-8'=>'(GMT-8) (PST)',
                            '-7'=>'(GMT-7) (MST)',
                            '-6'=>'(GMT-6) (CST)',
                            '-5'=>'(GMT-5) (EST)',
                            '-4'=>'(GMT - 4) Santiago',
                            '-3'=>'(GMT - 3) Buenos Aires',
                            '-2'=>'(GMT - 2) Mid-Atlantic',
                            '-1'=>'(GMT - 1) Azoren',
                            '0'=>'(GMT)',
                            '1'=>'(GMT + 1) Madrid',
                            '2'=>'(GMT + 2) Athen',
                            '3'=>'(GMT + 3) Moskau',
                            '4'=>'(GMT + 4) Kabul',
                            '5'=>'(GMT + 5) Jekaterinenburg',
                            '6'=>'(GMT + 6) Astana',
                            '7'=>'(GMT + 7) Bangkok',
                            '8'=>'(GMT + 8) Perth',
                            '9'=>'(GMT + 9) Seoul',
                            '10'=>'(GMT + 10) Brisbane',
                            '11'=>'(GMT + 11) Salomoninseln',
                            '12'=>'(GMT + 12) Auckland',
                            ),

        'wflow_fire_order_dom' => array('alerts_actions'=>'Warnungen, dann Aktionen',
                                    'actions_alerts'=>'Aktionen dann Warnungen'),




    'duration_intervals' => array('0'=>'00',
                                    '15'=>'15',
                                    '30'=>'30',
                                    '45'=>'45'),


// deferred
/*// QUEUES MODULE DOMs
'queue_type_dom' => array(
    'Users' => 'Benutzer',

    'Teams' => 'Teams',

    'Mailbox' => 'Mailbox',
),
*/

//prospect list type dom
  'prospect_list_type_dom' =>
  array (
    'default' => 'Standard',
    'seed' => 'Muster',
    'exempt_domain' => 'Unterdrückungs Liste - nach Domäne',
    'exempt_address' => 'Unterdrückungs Liste - nach E-Mail Adresse',
    'exempt' => 'Unterdrückungs Liste - nach ID',
    'test' => 'Test',
  ),

  'email_marketing_status_dom' =>
  array (
    '' => '',
    'active'=>'Aktiv',
    'inactive'=>'Inaktiv'
  ),

  'campainglog_activity_type_dom' =>
  array (
    ''=>'',
    'targeted' => 'Nachricht gesendet/versucht',
    'send error'=>'Nicht zustellbar, andere',
    'invalid email'=>'Nicht zustellbar, ungültige E-Mail',
    'link'=>'Klickbarer Link',
    'viewed'=>'Gelesene Mitteilung',
    'removed'=>'Keine E-Mails',
    'lead'=>'Erstellte Intessenten',
    'contact'=>'Neue Kontakte',
    'blocked'=>'Abgelehnt durch Adresse oder Domain',
  ),

  'campainglog_target_type_dom' =>
  array (
    'Contacts' => 'Kontakte',
    'Users'=>'Benutzer',
    'Prospects'=>'Zielkontakte',
    'Leads'=>'Interessenten',
  ),

  'merge_operators_dom' => array (
    'like'=>'Enthält',
    'exact'=>'Genau',
    'start'=>'Beginnt mit',
  ),

  'custom_fields_merge_dup_dom'=> array (
        0=>'Inaktiv',
        1=>'Aktiv',

        2=>'Im Filter',
        3=>'Standard gewählter Filter',
        4=>'Nur Filter',

  ),

  'navigation_paradigms' => array(
        'm'=>'Module',
        'gm'=>'Gruppierte Module',
  ),



    // Contracts module enums

    'contract_status_dom' => array (
        'notstarted' => 'Nicht begonnen',
        'inprogress' => 'In Bearbeitung',
        'signed' => 'Unterzeichnet',
    ),

    'contract_type_dom' => array (
        'type1' => 'Vertragstyp 1',
        'type2' => 'Vertragstyp 2',
        'type3' => 'Vertragstyp 3',
    ),

    'contract_payment_frequency_dom' => array (
        'monthly' => 'Monatlich',
        'quarterly' => 'alle 3 Monate',
        'halfyearly' => 'Halbjährlich',
        'yearly' => 'Jährlich',
    ),

    'contract_expiration_notice_dom' => array (
        '1' => '1 Tag',
        '3' => '3 Tage',
        '5' => '5 Tage',
        '7' => '1 Woche',
        '14' => '2 Wochen',
        '21' => '3 Wochen',
        '31' => '1 Monat',
    ),

     'oc_status_dom' =>
     array (
     '' => '',
     'Active' => 'Aktiv',
    'Inactive' => 'Inaktiv',
    ),



    'projects_priority_options' => array (
        'high'      => 'Hoch',
        'medium'    => 'Mittel',
        'low'       => 'Niedrig',
    ),

    'projects_status_options' => array (
        'notstarted'    => 'Nicht begonnen',
        'inprogress'    => 'In Bearbeitung',
        'completed'     => 'Abgeschlossen',
    ),

    // strings to pass to Flash charts
    'chart_strings' => array (
        'expandlegend'      => 'Legende anzeigen',
        'collapselegend'    => 'Legende verbergen',
        'clickfordrilldown' => 'Klick für Drilldown',
        'drilldownoptions'  => 'Drill Down Optionen',
        'detailview'        => 'Detailansicht...',
        'piechart'          => 'Tortendiagramm',
        'groupchart'        => 'Gruppendiagramm',
        'stackedchart'      => 'Stapelgrafik',
        'horizontalchart'   => 'Waagrechtes Diagramm',
        'linechart'         => 'Liniendiagramm',
        'noData'            => 'Daten nicht verfügbar',
        'pieWedgeName'      => 'Segment',
    ),

    'pipeline_chart_dom' => array (
    	'fun'	=> 'Trichter',
    	'hbar'	=> 'Waagrechter Balken',
    ),

);

$app_strings = array (
    'LBL_OUTBOUND_EMAIL_ADD_SERVER'         => 'Server hinzufügen...',

    'LBL_ROUTING_ADD_RULE'                  => 'Regel hinzufügen',
    'LBL_ROUTING_ALL'                       => 'Alle',
    'LBL_ROUTING_ANY'                       => 'Irgendeine',
    'LBL_ROUTING_BREAK'                     => '-',
    'LBL_ROUTING_BUTTON_CANCEL'             => 'Abbrechen',
    'LBL_ROUTING_BUTTON_SAVE'               => 'Regel speichern',

    'LBL_ROUTING_ACTIONS_COPY_MAIL'         => 'E-Mail kopieren',
    'LBL_ROUTING_ACTIONS_DELETE_BEAN'       => 'Sugar Objekt löschen',
    'LBL_ROUTING_ACTIONS_DELETE_FILE'       => 'Datei löschen',
    'LBL_ROUTING_ACTIONS_DELETE_MAIL'       => 'E-Mail löschen',
    'LBL_ROUTING_ACTIONS_FORWARD'           => 'E-Mail weiterleiten',
    'LBL_ROUTING_ACTIONS_MARK_FLAGGED'      => 'E-Mail markieren',
    'LBL_ROUTING_ACTIONS_MARK_READ'         => 'Als gelesen markieren',
    'LBL_ROUTING_ACTIONS_MARK_UNREAD'       => 'Als ungelesen markieren',
    'LBL_ROUTING_ACTIONS_MOVE_MAIL'         => 'E-Mail verschieben',
    'LBL_ROUTING_ACTIONS_PEFORM'            => 'Die folgende Aktion durchführen',
    'LBL_ROUTING_ACTIONS_REPLY'             => 'Auf E-Mail antworten',

    'LBL_ROUTING_CHECK_RULE'                => "Ein Fehler wurde gefunden:\n",
    'LBL_ROUTING_CHECK_RULE_DESC'           => 'Bitte überprüfen ob alle Felder markiert sind.',
    'LBL_ROUTING_CONFIRM_DELETE'            => "Sind Sie sicher, dass Sie diese Regel löschen wollen?\nDas kann nicht rückgängig gemacht werden.",

    'LBL_ROUTING_FLAGGED'                   => 'Markierung gesetzt',
    'LBL_ROUTING_FORM_DESC'                 => 'Gespeicherte Regeln sind sofort aktiv.',
    'LBL_ROUTING_FW'                        => 'FW: ',
    'LBL_ROUTING_LIST_TITLE'                => 'Regeln',
    'LBL_ROUTING_MATCH'                     => 'Wenn',
    'LBL_ROUTING_MATCH_2'                   => 'eine der folgende Bedingungen zutrifft:',

    'LBL_ROUTING_MATCH_CC_ADDR'             => 'CC',
    'LBL_ROUTING_MATCH_DESCRIPTION'         => 'Mailinhalt',
    'LBL_ROUTING_MATCH_FROM_ADDR'           => 'Von',
    'LBL_ROUTING_MATCH_NAME'                => 'Betreff',
    'LBL_ROUTING_MATCH_PRIORITY_HIGH'       => 'Hohe Priorität',
    'LBL_ROUTING_MATCH_PRIORITY_NORMAL'     => 'Normale Priorität',
    'LBL_ROUTING_MATCH_PRIORITY_LOW'        => 'Niedrige Priorität',
    'LBL_ROUTING_MATCH_TO_ADDR'             => 'An',
    'LBL_ROUTING_MATCH_TYPE_MATCH'          => 'Enthält',
    'LBL_ROUTING_MATCH_TYPE_NOT_MATCH'      => 'Enthält nicht',

    'LBL_ROUTING_NAME'                      => 'Regelname',
    'LBL_ROUTING_NEW_NAME'                  => 'Neue Regel',
    'LBL_ROUTING_ONE_MOMENT'                => 'Einen Moment bitte...',
    'LBL_ROUTING_ORIGINAL_MESSAGE_FOLLOWS'  => 'Originalnachricht folgt.',
    'LBL_ROUTING_RE'                        => 'RE: ',
    'LBL_ROUTING_SAVING_RULE'               => 'Regel speichern',
    'LBL_ROUTING_SUB_DESC'                  => 'Ausgewähle Regeln sind aktiv. Wählen Sie einen Namen um zu bearbeiten.',
    'LBL_ROUTING_TO'                        => 'bis',
    'LBL_ROUTING_TO_ADDRESS'                => 'an Adresse',
    'LBL_ROUTING_WITH_TEMPLATE'             => 'mit Vorlage',

    'LBL_EMAIL_ACCOUNTS_EDIT'               => 'Bearbeiten',
    'LBL_EMAIL_ACCOUNTS_GMAIL_DEFAULTS'     => 'Gmail Standard Einstellungen setzen',
    'LBL_EMAIL_ACCOUNTS_NAME'               => 'Name',
    'LBL_EMAIL_ACCOUNTS_OUTBOUND'           => 'Ausgehender Mail Server',
    'LBL_EMAIL_ACCOUNTS_SENDTYPE'           => 'Mail Transfer Agent',
    'LBL_EMAIL_ACCOUNTS_SMTPAUTH_REQ'       => 'SMTP Authentfiizierung verwenden?',
    'LBL_EMAIL_ACCOUNTS_SMTPPASS'           => 'SMTP Kennwort',
    'LBL_EMAIL_ACCOUNTS_SMTPPORT'           => 'SMTP Port',
    'LBL_EMAIL_ACCOUNTS_SMTPSERVER'         => 'SMTP Server',
    'LBL_EMAIL_ACCOUNTS_SMTPSSL'            => 'SSL bei der Verbindung verwenden',
    'LBL_EMAIL_ACCOUNTS_SMTPUSER'           => 'SMTP Benutzername',
    'LBL_EMAIL_ACCOUNTS_TITLE'              => 'E-Mail Konto Verwaltung',

    'LBL_EMAIL_ADD'                         => 'E-Mail hinzufügen',

    'LBL_EMAIL_ADDRESS_BOOK_ADD'            => 'Hinzufügen',
    'LBL_EMAIL_ADDRESS_BOOK_ADD_LIST'       => 'Liste hinzufügen',
    'LBL_EMAIL_ADDRESS_BOOK_EMAIL_ADDR'     => 'E-Mail Adresse',
    'LBL_EMAIL_ADDRESS_BOOK_ERR_NOT_CONTACT'=> 'Momentan können nur Kontakte editiert werden.',
    'LBL_EMAIL_ADDRESS_BOOK_FILTER'         => 'Filter',
    'LBL_EMAIL_ADDRESS_BOOK_FIRST_NAME'     => 'Vorname',
    'LBL_EMAIL_ADDRESS_BOOK_LAST_NAME'      => 'Nachname',
    'LBL_EMAIL_ADDRESS_BOOK_MY_CONTACTS'    => 'Meine Kontakte',
    'LBL_EMAIL_ADDRESS_BOOK_MY_LISTS'       => 'Meine Verteilerliste',
    'LBL_EMAIL_ADDRESS_BOOK_NAME'           => 'Name',
    'LBL_EMAIL_ADDRESS_BOOK_NOT_FOUND'      => 'Keine Adressen gefunden',
    'LBL_EMAIL_ADDRESS_BOOK_SAVE_AND_ADD'   => 'Speichern & zum Adressbuch hinzufügen',
    'LBL_EMAIL_ADDRESS_BOOK_SEARCH'         => 'Suchen',
    'LBL_EMAIL_ADDRESS_BOOK_SELECT_TITLE'   => 'Adressbuch Einträge auswählen',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE'          => 'Adressbuch',
    'LBL_EMAIL_REPORTS_TITLE'				=> 'Berichte',
    'LBL_EMAIL_ADDRESS_BOOK_TITLE_ICON'     => '<img src=themes/default/images/icon_email_addressbook.gif align=absmiddle border=0> Adressbuch',

    'LBL_EMAIL_ADDRESSES'                   => 'E-Mail Adresse(n)',
    'LBL_EMAIL_ADDRESS_PRIMARY'                   => 'E-Mail Adresse',
    'LBL_EMAIL_ADDRESSES_TITLE'             => 'E-Mail Adressen',
    'LBL_EMAIL_ARCHIVE_TO_SUGAR'            => 'Importiere nach Sugar',
    'LBL_EMAIL_ATTACH_FILE_TO_EMAIL'        => 'Datei an E-Mail anhängen',
    'LBL_EMAIL_ATTACHMENT'                  => 'Anhängen',
    'LBL_EMAIL_ATTACHMENTS'                 => 'Dateien anhängen',
    'LBL_EMAIL_ATTACHMENTS2'                => 'Sugar Dokumente anhängen',
    'LBL_EMAIL_ATTACHMENTS3'                => 'Anhangvorlage',
    'LBL_EMAIL_BCC'                         => 'BCC',
    'LBL_EMAIL_CANCEL'                      => 'Abbrechen',
    'LBL_EMAIL_CC'                          => 'CC',
    'LBL_EMAIL_CHARSET'                     => 'Zeichensatz',
    'LBL_EMAIL_CHECK'                       => 'E-Mails holen',
    'LBL_EMAIL_CHECKING_NEW'                => 'Nach neuen E-Mails überprüfen',
    'LBL_EMAIL_CHECKING_DESC'               => 'Hole E-Mails.<br><br>Bei neu angelegten E-Mail Konten kann der Vorgang etwas länger dauern. Bitte warten...',
    'LBL_EMAIL_CLOSE'                       => 'Schließen',
    'LBL_EMAIL_COFFEE_BREAK'                => 'Hole E-Mails.<br><br>Bei großen E-Mailkonten kann der Vorgang ggf. sehr lange dauern. Bitte warten...',
    'LBL_EMAIL_COMMON'                      => 'Allgemein',

    'LBL_EMAIL_COMPOSE'                     => 'Neue E-Mail',
    'LBL_EMAIL_COMPOSE_ERR_NO_RECIPIENTS'   => 'Bitte Empfänger angeben',
    'LBL_EMAIL_COMPOSE_LINK_TO'             => 'Gehört zu',
    'LBL_EMAIL_COMPOSE_NO_BODY'             => 'Diese E-Mail hat keinen Inhalt. Trotzdem senden?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT'          => 'Diese E-Mail hat kein Betreff. Trotzdem senden?',
    'LBL_EMAIL_COMPOSE_NO_SUBJECT_LITERAL'  => '(kein Betreff)',
    'LBL_EMAIL_COMPOSE_READ'                => 'Lesen & neue E-Mail',
    'LBL_EMAIL_COMPOSE_SEND_FROM'           => 'Senden von E-Mail Konto',
    'LBL_EMAIL_COMPOSE_OPTIONS'             => 'Optionen',
    'LBL_EMAIL_COMPOSE_INVALID_ADDRESS'     => 'Bitte eine gültige E-Mail Adresse in An, CC und BCC verwenden',

    'LBL_EMAIL_CONFIRM_CLOSE'               => 'E-Mail verwerfen?',
    'LBL_EMAIL_CONFIRM_DELETE'              => 'Diese Einträge aus dem Adressbuch entfernen?',

    'LBL_EMAIL_CREATE_NEW'                  => '--Erstellen beim Speichern--',

    'LBL_EMAIL_DATE_RECEIVED'               => 'Empfangsdatum',
    'LBL_EMAIL_ASSIGNED_TO_USER'            =>'Bearbeiter',
    'LBL_EMAIL_DATE_TODAY'                  => 'Heute',
    'LBL_EMAIL_DATE_YESTERDAY'              => 'Gestern',
    'LBL_EMAIL_DD_TEXT'                     => 'Ausgewählte E-Mail(s).',
    'LBL_EMAIL_DEFAULTS'                    => 'Standardwerte',
    'LBL_EMAIL_DELETE'                      => 'Löschen',
    'LBL_EMAIL_DELETE_CONFIRM'              => 'Ausgewählte Nachrichten löschen?',
    'LBL_EMAIL_DELETE_SUCCESS'              => 'E-Mail erfolgreich gelöscht.',
    'LBL_EMAIL_DELETING_MESSAGE'            => 'Nachricht wird gelöscht',
    'LBL_EMAIL_DETAILS'                     => 'Details',
    'LBL_EMAIL_DISPLAY_MSG'                 => 'E-Mail(s) anzeigen {0} - {1} von {2}',
    'LBL_EMAIL_ADDR_DISPLAY_MSG'            => 'E-Mail Adresse(n) anzeigen {0} - {1} von {2}',

    'LBL_EMAIL_EDIT_CONTACT'                => 'Kontakt bearbeiten',
    'LBL_EMAIL_EDIT_CONTACT_WARN'           => 'Bei Kontakten wird nur die Hauptadresse verwendet',
    'LBL_EMAIL_EDIT_MAILING_LIST'           => 'Verteilerliste anpassen',

    'LBL_EMAIL_EMPTYING_TRASH'              => 'Gelöschte Objekte entfernen',
    'LBL_EMAIL_EMPTY_MSG'                   => 'Keine E-Mails vorhanden.',
    'LBL_EMAIL_EMPTY_ADDR_MSG'              => 'Keine E-Mail Adressen zu zeigen.',

    'LBL_EMAIL_ERROR_ADD_GROUP_FOLDER'      => 'Ordnernamen müssen eindeutig und nicht leer sein. Bitte nochmals versuchen',
    'LBL_EMAIL_ERROR_DELETE_GROUP_FOLDER'   => 'Der Ordner kann nicht gelöscht werden. Dieser bzw. Unterordner haben eine Mailbox zugeordnet.',
    'LBL_EMAIL_ERROR_CANNOT_FIND_NODE'      => 'Der Ordner kann vom Inhalt her nicht bestimmt werden.  Bitte nochmals versuchen.',
    'LBL_EMAIL_ERROR_CHECK_IE_SETTINGS'     => 'Bitte die Einstellungen überprüfen.',
    'LBL_EMAIL_ERROR_CONTACT_NAME'          => 'Bitte Nachnamen eintragen.',
    'LBL_EMAIL_ERROR_DESC'                  => 'Fehler gefunden:',
    'LBL_EMAIL_DELETE_ERROR_DESC'           => 'Sie haben keinen Zugang zu diesem Bereich. Bitte kontaktieren Sie den Administrator, wenn Sie glauben, dass Sie Zugang haben sollten.',
    'LBL_EMAIL_ERROR_DUPE_FOLDER_NAME'      => 'Sugar Ordnernamen müssen eindeutig sein.',
    'LBL_EMAIL_ERROR_EMPTY'                 => 'Bitte Suchkriterien eingeben.',
    'LBL_EMAIL_ERROR_GENERAL_TITLE'         => 'Ein Fehler ist aufgetreten',
    'LBL_EMAIL_ERROR_LIST_NAME'             => 'Eine E-Mail Liste mit diesem Namen existiert bereits',
    'LBL_EMAIL_ERROR_MESSAGE_DELETED'       => 'Nachricht vom Server entfernt',
    'LBL_EMAIL_ERROR_IMAP_MESSAGE_DELETED'  => 'Die E-Mail wurde entweder entfernt oder in einen anderen Ordner verschoben',
    'LBL_EMAIL_ERROR_MAILSERVERCONNECTION'  => 'Keine Verbindung mit dem Mailserver. Bitte kontaktieren Sie Ihren Administrator',
    'LBL_EMAIL_ERROR_MOVE'                  => 'E-Mails zwischen Servern und/oder Mailkonten zu verschieben wird momentan nicht unterstüzt.',
    'LBL_EMAIL_ERROR_MOVE_TITLE'            => 'Fehler beim Verschieben.',
    'LBL_EMAIL_ERROR_NAME'                  => 'Ein Name wird benötigt.',
    'LBL_EMAIL_ERROR_FROM_ADDRESS'          => 'Von Adresse ist ein Pflichtfeld.',
    'LBL_EMAIL_ERROR_NO_FILE'               => 'Bitte eine Datei auswählen.',
    'LBL_EMAIL_ERROR_NO_IMAP_FOLDER_RENAME' => 'IMAP Ordner können derzeit nicht umbenannt werden.',
    'LBL_EMAIL_ERROR_SERVER'                => 'Eine Mailserverkonto wird benötigt.',
    'LBL_EMAIL_ERROR_SAVE_ACCOUNT'          => 'Das E-Mail-Konto könnte nicht gespeichert worden sein.',
    'LBL_EMAIL_ERROR_TIMEOUT'               => 'Kommunikationsfehler mit dem Mailserver',
    'LBL_EMAIL_ERROR_USER'                  => 'Ein Loginname wird benötigt.',
    'LBL_EMAIL_ERROR_PASSWORD'              => 'Ein Kennwort wird benötigt.',
    'LBL_EMAIL_ERROR_PORT'                  => 'Ein Mailserver-Port wird benötigt.',
    'LBL_EMAIL_ERROR_PROTOCOL'              => 'Ein Mailserver-Protokoll wird benötigt.',
    'LBL_EMAIL_ERROR_VIEW_RAW_SOURCE'       => 'Diese Information ist nicht verfügbar',

    'LBL_EMAIL_FOLDERS'                     => '<img src=themes/default/images/icon_email_folder.gif align=absmiddle border=0> Ordner',
    'LBL_EMAIL_FOLDERS_ACTIONS'             => 'Verschiebe nach',
    'LBL_EMAIL_FOLDERS_ADD'                 => 'Hinzufügen',
    'LBL_EMAIL_FOLDERS_ADD_DIALOG_TITLE'    => 'Ordner hinzufügen',
    'LBL_EMAIL_FOLDERS_ADD_NEW_FOLDER'      => 'Gruppenordner hinzufügen',
    'LBL_EMAIL_FOLDERS_ADD_THIS_TO'         => 'Dieser Ordner hinzufügen zu',
    'LBL_EMAIL_FOLDERS_CHANGE_HOME'         => 'Dieser Ordner kann nicht umbenannt werden',
    'LBL_EMAIL_FOLDERS_DELETE_CONFIRM'      => 'Wollen Sie diesen Ordner wirklich löschen?\nDieser Vorgang kann nicht rückgängig gemacht werden.\nAlle Unterordner werden auch gelöscht.',
    'LBL_EMAIL_FOLDERS_NEW_FOLDER'          => 'Neuer Ordner',
    'LBL_EMAIL_FOLDERS_NO_VALID_NODE'       => 'Bevor diese Aktion durchgeführt werden kann bitte zuerst einen Ordner auswählen,',
    'LBL_EMAIL_FOLDERS_TITLE'               => 'Sugar Ordnerverwaltung',
    'LBL_EMAIL_FOLDERS_USING_GROUP_USER'    => 'Gruppe verwenden',

    'LBL_EMAIL_FOLDERS_USING_TEAM'          => 'Einem Team zuordnen',


    'LBL_EMAIL_FORWARD'                     => 'Vorwärts',
    'LBL_EMAIL_DELIMITER'                   => '::;::',
    'LBL_EMAIL_FOUND'                       => 'Gefunden',
    'LBL_EMAIL_FROM'                        => 'Von',
    'LBL_EMAIL_GROUP'                       => 'Gruppe',
    'LBL_EMAIL_HOME_FOLDER'                 => 'Home',
    'LBL_EMAIL_HTML_RTF'                    => 'Sende HTML',
    'LBL_EMAIL_IE_DELETE'                   => 'E-Mailkonto löschen',
    'LBL_EMAIL_IE_DELETE_CONFIRM'           => 'Wollen Sie dieses E-Mailkonto wirklich löschen?',
    'LBL_EMAIL_IE_DELETE_SUCCESSFUL'        => 'Erfolgreich gelöscht.',
    'LBL_EMAIL_IE_SAVE'                     => 'Mailkonto Information speichern',
    'LBL_EMAIL_IMPORTING_EMAIL'             => 'E-Mail importieren',
    'LBL_EMAIL_IMPORT_EMAIL'                => 'Importiere nach Sugar',
    'LBL_EMAIL_INVALID'                     => 'Ungültig',

    'LBL_EMAIL_LIST_RENAME_TITLE'           => 'Verteilerliste umbenennen',
    'LBL_EMAIL_LIST_RENAME_DESC '           => 'Geben Sie einen neuen Namen für diese Verteilerliste ein',
    'LBL_EMAIL_CONFIRM_DELETE_LIST'         => 'Diese Einträge aus Ihrer Verteilerliste entfernen?',

    'LBL_EMAIL_LOADING'                     => 'Lade...',
    'LBL_EMAIL_MARK'                        => 'Markiere',
    'LBL_EMAIL_MARK_FLAGGED'                => 'Wie markiert',
    'LBL_EMAIL_MARK_READ'                   => 'Als gelesen',
    'LBL_EMAIL_MARK_UNFLAGGED'              => 'Als nicht markiert',
    'LBL_EMAIL_MARK_UNREAD'                 => 'Als ungelesen',
    'LBL_EMAIL_ASSIGN_TO'                   => 'Zuweisen an',

    'LBL_EMAIL_MENU_ADD_FOLDER'             => 'Ordner erstellen',
    'LBL_EMAIL_MENU_COMPOSE'                => 'Neue E-Mail',
    'LBL_EMAIL_MENU_DELETE_FOLDER'          => 'Ordner löschen',
    'LBL_EMAIL_MENU_EDIT'                   => 'Bearbeiten',
    'LBL_EMAIL_MENU_EMPTY_TRASH'            => 'Papierkorb leeren',
    'LBL_EMAIL_MENU_SYNCHRONIZE'            => 'Synchronisieren',
    'LBL_EMAIL_MENU_REMOVE'                 => 'Entfernen',
    'LBL_EMAIL_MENU_RENAME'                 => 'Umbennenen',
    'LBL_EMAIL_MENU_RENAME_FOLDER'          => 'Ordner umbennenen',
    'LBL_EMAIL_MENU_RENAMING_FOLDER'        => 'Ordner umbennenen',
    'LBL_EMAIL_MENU_MAKE_SELECTION'         => 'Etwas auswählen, bevor dieser Vorgang durchgeführt werden kann.',

    'LBL_EMAIL_MENU_HELP_ADD_FOLDER'        => 'Ordner erstellen (Remote oder in Sugar)',
    'LBL_EMAIL_MENU_HELP_ARCHIVE'           => 'E-Mail(s) nach SugarCRM archiveren',
    'LBL_EMAIL_MENU_HELP_COMPOSE_TO_LIST'   => 'Verteilerliste für diese E-Mail',
    'LBL_EMAIL_MENU_HELP_CONTACT_COMPOSE'   => 'E-Mail an diesen Kontakt',
    'LBL_EMAIL_MENU_HELP_CONTACT_REMOVE'    => 'Kontakt entfernen',
    'LBL_EMAIL_MENU_HELP_DELETE'            => 'Diese E-Mail(s) löschen',
    'LBL_EMAIL_MENU_HELP_DELETE_FOLDER'     => 'Ordner löschen (Remote oder in Sugar)',
    'LBL_EMAIL_MENU_HELP_EDIT_CONTACT'      => 'Kontakt bearbeiten',
    'LBL_EMAIL_MENU_HELP_EDIT_LIST'         => 'Verteilerliste bearbeiten',
    'LBL_EMAIL_MENU_HELP_EMPTY_TRASH'       => 'Alle Papierkörbe für Ihre Mailkonten löschen',
    'LBL_EMAIL_MENU_HELP_MARK_FLAGGED'      => 'Diese E-Mail(s) markieren',
    'LBL_EMAIL_MENU_HELP_MARK_READ'         => 'Diese E-Mail(s) als gelesen markieren',
    'LBL_EMAIL_MENU_HELP_MARK_UNFLAGGED'    => 'Markierung dieser E-Mail(s) aufheben',
    'LBL_EMAIL_MENU_HELP_MARK_UNREAD'       => 'Diese E-Mail(s) als ungelesen markieren',
    'LBL_EMAIL_MENU_HELP_REMOVE_LIST'       => 'Entfernt Verteilerlisten',
    'LBL_EMAIL_MENU_HELP_RENAME_FOLDER'     => 'Ordner umbennenen (Remote oder in Sugar)',
    'LBL_EMAIL_MENU_HELP_REPLY'             => 'Auf diese E-Mail(s) antworten',
    'LBL_EMAIL_MENU_HELP_REPLY_ALL'         => 'Allen Empfängern dieser E-Mail(s) antworten',

    'LBL_EMAIL_MESSAGES'                    => 'Nachrichten',

    'LBL_EMAIL_ML_NAME'                     => 'Verteilerliste Name',
    'LBL_EMAIL_ML_ADDRESSES_1'              => 'Adressen für Verteilerliste auswählen',
    'LBL_EMAIL_ML_ADDRESSES_2'              => 'Verfügbare Verteilerliste Adressen',

    'LBL_EMAIL_MULTISELECT'                 => '<b>STRG-Click</b> um mehrere Sätze auszuwählen<br />(Für Mac Benutzer <b>CMD-Click</b>)',

    'LBL_EMAIL_NO'                          => 'Nein',

    'LBL_EMAIL_OK'                          => 'OK',
    'LBL_EMAIL_ONE_MOMENT'                  => 'Einen Moment bitte...',
    'LBL_EMAIL_OPEN_ALL'                    => 'Mehrere Nachrichten öffnen',
    'LBL_EMAIL_OPTIONS'                     => 'Optionen',
    'LBL_EMAIL_OPT_OUT'                     => 'Keine E-Mails',
    'LBL_EMAIL_PAGE_AFTER'                  => 'von {0}',
    'LBL_EMAIL_PAGE_BEFORE'                 => 'Seite',
    'LBL_EMAIL_PERFORMING_TASK'             => 'Aufgabe wird durchgeführt',
    'LBL_EMAIL_PRIMARY'                     => 'Primär',
    'LBL_EMAIL_PRINT'                       => 'Drucken',

    'LBL_EMAIL_QC_BUGS'                     => 'Fehler',
    'LBL_EMAIL_QC_CASES'                    => 'Fall',
    'LBL_EMAIL_QC_LEADS'                    => 'Interessent',
    'LBL_EMAIL_QC_CONTACTS'                 => 'Kontakt',
    'LBL_EMAIL_QC_TASKS'                    => 'Aufgabe',
    'LBL_EMAIL_QUICK_CREATE'                => 'Schnellerfassung',

    'LBL_EMAIL_REBUILDING_FOLDERS'          => 'Ordner werden neu aufgebaut',
    'LBL_EMAIL_RELATE_TO'                   => 'Verbinden',
    'LBL_EMAIL_REMOVE'                      => 'Entfernen',
    'LBL_EMAIL_REPLY'                       => 'Antworten',
    'LBL_EMAIL_REPLY_ALL'                   => 'Allen antworten',
    'LBL_EMAIL_REPLY_TO'                    => 'Antworte an',
    'LBL_EMAIL_RETRIEVING_LIST'             => 'E-Mail Liste holen',
    'LBL_EMAIL_RETRIEVING_MESSAGE'          => 'Nachrichten holen',
    'LBL_EMAIL_RETURN_TO_VIEW'              => 'Zurück zum vorherigen Modul?',
    'LBL_EMAIL_REVERT'                      => 'Zurückkehren',

    'LBL_EMAIL_RULES_TITLE'                 => 'Regel Management',

    'LBL_EMAIL_SAVE'                        => 'Speichern',
    'LBL_EMAIL_SAVE_AND_REPLY'              => 'Speichern und Antworten',
    'LBL_EMAIL_SAVE_DRAFT'                  => 'Entwurf speichern',

    'LBL_EMAIL_SEARCHING'                   => 'Es wird gesucht.....',
    'LBL_EMAIL_SEARCH'                      => '<img src=themes/default/images/Search.gif align=absmiddle border=0> Suche',
    'LBL_EMAIL_SEARCH_ADVANCED'             => 'Erweiterte Suche',
    'LBL_EMAIL_SEARCH_DATE_FROM'            => 'Von Datum',
    'LBL_EMAIL_SEARCH_DATE_UNTIL'           => 'Bis Datum',
    'LBL_EMAIL_SEARCH_FULL_TEXT'            => 'Textkörper',
    'LBL_EMAIL_SEARCH_NO_RESULTS'           => 'Keine passenden Treffer.',
    'LBL_EMAIL_SEARCH_RESULTS_TITLE'        => 'Suchergebnisse',
    'LBL_EMAIL_SEARCH_TITLE'                => 'Einfache Suche',
    'LBL_EMAIL_SEARCH__FROM_ACCOUNTS'       => 'Suche E-Mail Konto',

    'LBL_EMAIL_SELECT'                      => 'Auswählen',

    'LBL_EMAIL_SEND'                        => 'Senden',
    'LBL_EMAIL_SENDING_EMAIL'               => 'E-Mail wird gesendet',

    'LBL_EMAIL_SETTINGS'                    => 'Einstellungen',
    'LBL_EMAIL_SETTINGS_2_ROWS'             => '2 Zeilen',
    'LBL_EMAIL_SETTINGS_3_COLS'             => '3 Spalten',
    'LBL_EMAIL_SETTINGS_LAYOUT'             => 'Layout Stil',
    'LBL_EMAIL_SETTINGS_ACCOUNTS'           => 'E-Mail Konten',
    'LBL_EMAIL_SETTINGS_ADD_ACCOUNT'        => 'Formular leeren',
    'LBL_EMAIL_SETTINGS_AUTO_IMPORT'        => 'E-Mail importieren beim Lesen',
    'LBL_EMAIL_SETTINGS_CHECK_INTERVAL'     => 'Nach neuen E-Mails überprüfen',
    'LBL_EMAIL_SETTINGS_COMPOSE_INLINE'     => 'Vorschau Fenster verwenden',
    'LBL_EMAIL_SETTINGS_COMPOSE_POPUP'      => 'Popup Fenster verwenden',
    'LBL_EMAIL_SETTINGS_DISPLAY_NUM'        => 'Anzahl E-Mails je Seite',
    'LBL_EMAIL_SETTINGS_EDIT_ACCOUNT'       => 'E-Mailkonto ändern',
    'LBL_EMAIL_SETTINGS_FOLDERS'            => 'Ordner',
    'LBL_EMAIL_SETTINGS_FROM_ADDR'          => 'Von Adresse',
    'LBL_EMAIL_SETTINGS_FROM_NAME'          => 'Von Name',
    'LBL_EMAIL_SETTINGS_FULL_SCREEN'        => 'Gesamter Bildschirm',
    'LBL_EMAIL_SETTINGS_FULL_SYNC'          => 'Alle Mailkonten synchronisieren',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_DESC'     => 'Dieser Vorgang synchronisiert alle Mailkonten und deren Inhalte.',
    'LBL_EMAIL_SETTINGS_FULL_SYNC_WARN'     => 'Eine volle Synchronisation durchführen?\nBei großen Konten kan dieser Vorgang einige Zeit benötigen.',
    'LBL_EMAIL_SETTINGS_GENERAL'            => 'Allgemein',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS'      => 'Verfügbare Gruppenordner',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_CREATE'   => 'Gruppenordner erstellen',
    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_Save' => 'Gruppenordner werden gespeichert',
    'LBL_EMAIL_SETTINGS_RETRIEVING_GROUP'   => 'Gruppenordner wieder holen',

    'LBL_EMAIL_SETTINGS_GROUP_FOLDERS_EDIT' => 'Gruppenordner bearbeiten',

    'LBL_EMAIL_SETTINGS_NAME'               => 'Name',
    'LBL_EMAIL_SETTINGS_REQUIRE_REFRESH'    => 'Diese Einstellungen werden erst nach einem Neuaufbau der Seite verfügbar.',
    'LBL_EMAIL_SETTINGS_RETRIEVING_ACCOUNT' => 'E-Maileinstellungen holen',
    'LBL_EMAIL_SETTINGS_RULES'              => 'Regeln',
    'LBL_EMAIL_SETTINGS_SAVED'              => 'Einstellungen gespeichert.\n\nSie müssen die Seite neu laden um die Einstellungen wirksam werden zu lassen.',
    'LBL_EMAIL_SETTINGS_SAVE_OUTBOUND'      => 'In den Ordner Gesendet kopieren',
    'LBL_EMAIL_SETTINGS_SEND_EMAIL_AS'      => 'E-Mail als Text senden',
    'LBL_EMAIL_SETTINGS_SHOW_IN_FOLDERS'    => 'Aktive E-Mailkonten',
    'LBL_EMAIL_SETTINGS_SHOW_NUM_IN_LIST'   => 'Anzahl E-Mails je Seite',
    'LBL_EMAIL_SETTINGS_TAB_POS'            => 'Tabs unten anzeigen',
    'LBL_EMAIL_SETTINGS_TITLE_LAYOUT'       => 'Visuelle Einstellungen',
    'LBL_EMAIL_SETTINGS_TITLE_PREFERENCES'  => 'Einstellungen',
    'LBL_EMAIL_SETTINGS_TOGGLE_ADV'         => 'Zeige erweiterte Einstellungen',
    'LBL_EMAIL_SETTINGS_USER_FOLDERS'       => 'Verfügbare Benutzerordner',

    'LBL_EMAIL_SHOW_READ'                   => 'Alle zeigen',
    'LBL_EMAIL_SHOW_UNREAD_ONLY'            => 'Alle ungelesenen zeigen',
    'LBL_EMAIL_SIGNATURES'                  => 'Signaturen',
    'LBL_EMAIL_SIGNATURE_CREATE'            => 'Signatur erstellen',
    'LBL_EMAIL_SIGNATURE_NAME'              => 'Signatur Name',
    'LBL_EMAIL_SIGNATURE_TEXT'              => 'Signatur Inhalt',
    'LBL_EMAIL_SPACER_MAIL_SERVER'          => '[ Remote Ordner ]',
    'LBL_EMAIL_SPACER_LOCAL_FOLDER'         => '[ Sugar Ordner ]',
    'LBL_EMAIL_SUBJECT'                     => 'Betreff',
    'LBL_EMAIL_SUCCESS'                     => 'Erfolg',
    'LBL_EMAIL_SUGAR_FOLDER'                => 'Sugar Ordner',

    'LBL_EMAIL_TEAMS'                       => 'Einem Team zuordnen',

    'LBL_EMAIL_TEMPLATES'                   => 'Vorlagen',
    'LBL_EMAIL_TEXT_FIRST'                  => 'Erste Seite',
    'LBL_EMAIL_TEXT_PREV'                   => 'Vorherige Seite',
    'LBL_EMAIL_TEXT_NEXT'                   => 'Nächste Seite',
    'LBL_EMAIL_TEXT_LAST'                   => 'Letzte Seite',
    'LBL_EMAIL_TEXT_REFRESH'                => 'Aktualisieren',
    'LBL_EMAIL_TO'                          => 'An',
    'LBL_EMAIL_TOGGLE_LIST'                 => 'Liste umschalten',
    'LBL_EMAIL_VIEW'                        => 'Ansicht',
    'LBL_EMAIL_VIEWS'                       => 'Ansichten',
    'LBL_EMAIL_VIEW_HEADERS'                => 'Kopfzeile anzeigen',
    'LBL_EMAIL_VIEW_PRINTABLE'              => 'Druckbare Version',
    'LBL_EMAIL_VIEW_RAW'                    => 'Rohe E-Mail anzeigen',
    'LBL_EMAIL_VIEW_UNSUPPORTED'            => 'Diese Funktion kann nicht mit POP3 verwendet werden.',
    'LBL_DEFAULT_LINK_TEXT'                 => 'Standard Link Text',
    'LBL_EMAIL_YES'                         => 'Ja',

    'LBL_EMAIL_CHECK_INTERVAL_DOM'          => array(
        '-1' => "Manuell",
        '5' => 'Alle 5 Minuten',
        '15' => 'Alle 15 Minuten',
        '30' => 'Alle 30 Minuten',
        '60' => 'Jede Stunde'
    ),
    'LBL_EMAIL_SETTING_NUM_DOM'             => array(
        '10'    => '10',
        '20'    => '20',
        '50'    => '50'
    ),

    'LBL_LINK_NONE'=> 'Kein(e)',
    'LBL_LINK_ALL'=> 'Alle',
    'LBL_LINK_RECORDS'=> 'Sätze',
    'LBL_LINK_SELECT'=> 'Auswählen',


    'LBL_LIST_TEAM' => 'Team',
    'LBL_TEAM' => 'Team:',
    'LBL_TEAM_ID'=>'Team ID:',



    'LBL_QUERY_VALID'=>'Gültig',
    'LBL_QUERY_ERROR'=>'Fehler!',
    'LBL_QUERY_CHILD'=>'Gültige Unterabfrage',
    'LBL_CLOSE_BUTTON_TITLE' => 'Schließen',
    'LBL_CLOSE_BUTTON_KEY' => 'C',
    'LBL_CLOSE_BUTTON_LABEL' => 'Schließen',
    'ERROR_EXAMINE_MSG' => 'Bitte studieren Sie die Fehlermeldung unten:',
    'NO_QUERY_SELECTED' => 'Das von Ihnen gewählte Datenformat enthält keine Abfrage. Bitte wählen Sie eine benutzerdefinierte Abfrage für dieses Datenformat aus.',


    'ERR_CREATING_FIELDS' => 'Fehler beim Ausfüllen von zusätzlichen Detailfeldern:',
    'ERR_CREATING_TABLE' => 'Fehler beim Anlegen der Tabelle:',
    'ERR_DECIMAL_SEP_EQ_THOUSANDS_SEP'  => "Die Dezimal- und Tausender-Trennzeichen müssen unterschiedlich sein.\n\nBitte die Werte ändern.",
    'ERR_DELETE_RECORD' => 'Um einen Kontakt zu löschen, muss die Nummer des Datensatzes angegeben werden.',
    'ERR_EXPORT_DISABLED' => 'Exporte deaktiviert',
    'ERR_EXPORT_TYPE' => 'Fehler beim Exportieren',
    'ERR_INVALID_AMOUNT' => 'Bitte gültigen Betrag eingeben.',
    'ERR_INVALID_DATE_FORMAT' => 'Das Datumsformat muss sein:',
    'ERR_INVALID_DATE' => 'Bitte ein gültiges Datum eingeben.',
    'ERR_INVALID_DAY' => 'Bitte einen gültigen Tag eingeben.',
    'ERR_INVALID_EMAIL_ADDRESS' => 'Keine gültige E-Mail Adresse.',
    'ERR_INVALID_FILE_REFERENCE' => 'Ungültige Datei-Referenz',
    'ERR_INVALID_HOUR' => 'Bitte eine gültige Stunde eingeben.',
    'ERR_INVALID_MONTH' => 'Bitte einen gültigen Monat eingeben.',
    'ERR_INVALID_TIME' => 'Bitte eine gültige Uhrzeit eingeben.',
    'ERR_INVALID_YEAR' => 'Bitte eine gültige Jahreszahl mit 4 Ziffern eingeben.',
    'ERR_NEED_ACTIVE_SESSION' => 'Um Inhalt zu exportieren muss eine aktive Session vorhanden sein.',
    'ERR_NO_HEADER_ID' => 'Diese Funktion ist für dieses Thema nicht verfügbar.',
    'ERR_NOT_ADMIN' => "Unautorisierter Zugriff auf die Administration.",
    'ERR_MISSING_REQUIRED_FIELDS' => 'Fehlendes Pflichtfeld:',
    'ERR_INVALID_VALUE' => 'Ungültiger Wert:',
    'ERR_NO_SUCH_FILE' =>'Diese Datei existiert im System nicht.',
    'ERR_NO_SINGLE_QUOTE' => 'Hochkomma kann nicht verwendet werden als',
    'ERR_NOTHING_SELECTED' =>'Bevor Sie weitermachen treffen Sie bitte erst eine Auswahl.',
    'ERR_OPPORTUNITY_NAME_DUPE' => 'Eine Verkaufschance mit dem Namen %s ist bereits vorhanden. Bitte einen anderen Namen eingeben.',
    'ERR_OPPORTUNITY_NAME_MISSING' => 'Es wurde kein Name eingegeben. Bitte geben Sie unten einen Namen für die Verkaufschance ein.',
    'ERR_POTENTIAL_SEGFAULT' => 'Ein möglicher Apache Segmentation Fault wurde gefunden. Bitte informieren Sie Ihren System Administrator um das Problem zu bestätigen damit er/sie SugarCRM informieren kann.',
    'ERR_SELF_REPORTING' => 'Mitarbeiter kann nicht an sich selbst berichten.',
    'ERR_SINGLE_QUOTE'  => 'Hochkommas werden für dieses Feld nicht unterstützt. Bitte ändern Sie den Wert.',
    'ERR_SQS_NO_MATCH_FIELD' => 'Kein passender Eintrag:',
    'ERR_SQS_NO_MATCH' =>'Kein Treffer',
    'ERR_ADDRESS_KEY_NOT_SPECIFIED' => 'Spezifizieren Sie den \'key\' index in displayParams attribute für die Meta-Data definition',
	'ERR_EXISTING_PORTAL_USERNAME'=>'Fehler: Der Portalname wurde bereits einer anderen Kontaktperson zugeordnet',

    'LBL_ACCOUNT'=>'Firma',
    'LBL_ACCOUNTS'=>'Firmen',
    'LBL_ACCUMULATED_HISTORY_BUTTON_KEY' => 'H',
    'LBL_ACCUMULATED_HISTORY_BUTTON_LABEL' => 'Zusammenfassung zeigen',
    'LBL_ACCUMULATED_HISTORY_BUTTON_TITLE' => 'Zusammenfassung zeigen [Alt+H]',
    'LBL_ADD_BUTTON_KEY' => 'A',
    'LBL_ADD_BUTTON_TITLE' => 'Hinzufügen [Alt+A]',
    'LBL_ADD_BUTTON' => 'Hinzufügen',
    'LBL_ADD_DOCUMENT' => 'Dokument hinzufügen',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_KEY' => 'L',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_LABEL' => 'Zur Zielpersonenliste hinzufügen',
    'LBL_ADD_TO_PROSPECT_LIST_BUTTON_TITLE' => 'Zur Zielpersonenliste hinzufügen',
    'LBL_ADDITIONAL_DETAILS_CLOSE_TITLE' => 'Zum Beenden klicken',
    'LBL_ADDITIONAL_DETAILS_CLOSE' => 'Schließen',
    'LBL_ADDITIONAL_DETAILS' => 'Weitere Details',
    'LBL_ADMIN' => 'Admin',
    'LBL_ALT_HOT_KEY' => 'Alt+',
    'LBL_ARCHIVE' => 'Archivieren',
    'LBL_ASSIGNED_TO_USER'=>'Bearbeiter',
    'LBL_ASSIGNED_TO' => 'Zugewiesen an:',
    'LBL_BACK' => 'Zurück',
    'LBL_BILL_TO_ACCOUNT'=>'Rechnung an Firma',
    'LBL_BILL_TO_CONTACT'=>'Rechnung an Kontaktperson',
    'LBL_BILLING_ADDRESS'=>'Rechnungsadresse',
    'LBL_BROWSER_TITLE' => 'SugarCRM - Kommerzielles Open-Source CRM',
    'LBL_BUGS'=>'Fehler',
    'LBL_BY' => 'von',
    'LBL_CALLS'=>'Anrufe',
    'LBL_CALL'=>'Anruf',
    'LBL_CAMPAIGNS_SEND_QUEUED' => 'Sende Kampagnen E-Mails in Warteschlange',
    'LBL_CANCEL_BUTTON_KEY' => 'X',
    'LBL_CANCEL_BUTTON_LABEL' => 'Abbrechen',
    'LBL_CANCEL_BUTTON_TITLE' => 'Abbrechen [Alt+X]',
    'LBL_SUBMIT_BUTTON_LABEL' => 'Ausführen',
    'LBL_CASE'=>'Fall',
    'LBL_CASES'=>'Fälle',
    'LBL_CHANGE_BUTTON_KEY' => 'G',
    'LBL_CHANGE_BUTTON_LABEL' => 'Ändern',
    'LBL_CHANGE_BUTTON_TITLE' => 'Ändern [Alt+G]',
    'LBL_CHARSET' => 'UTF-8',
    'LBL_CHECKALL' => 'Alle markieren',
    'LBL_CITY' => 'Stadt',
    'LBL_CLEAR_BUTTON_KEY' => 'C',
    'LBL_CLEAR_BUTTON_LABEL' => 'Leeren',
    'LBL_CLEAR_BUTTON_TITLE' => 'Leeren [Alt+C]',
    'LBL_CLEARALL' => 'Alle Markierungen entfernen',
    'LBL_CLOSE_WINDOW'=>'Fenster schließen',
    'LBL_CLOSEALL_BUTTON_KEY' => 'Q',
    'LBL_CLOSEALL_BUTTON_LABEL' => 'Alle schließen',
    'LBL_CLOSEALL_BUTTON_TITLE' => 'Alle schließen [Alt+I]',
    'LBL_CLOSE_AND_CREATE_BUTTON_LABEL' => 'Schließen & Neu',
    'LBL_CLOSE_AND_CREATE_BUTTON_TITLE' => 'Schließen & Neu',
    'LBL_CLOSE_AND_CREATE_BUTTON_KEY' => 'C',
    'LBL_COMPOSE_EMAIL_BUTTON_KEY' => 'L',
    'LBL_COMPOSE_EMAIL_BUTTON_LABEL' => 'Neue E-Mail',
    'LBL_COMPOSE_EMAIL_BUTTON_TITLE' => 'Neue E-Mail [Alt+E]',
    'LBL_CONTACT_LIST' => 'Kontakt Liste',
    'LBL_CONTACT'=>'Kontakt',
    'LBL_CONTACTS'=>'Kontakte',
    'LBL_COUNTRY' => 'Land:',
    'LBL_CREATE_BUTTON_LABEL' => 'Erstellen',
    'LBL_CREATED_BY_USER'=>'Erstellt von Benutzer:',
    'LBL_CREATED' => 'Erstellt von:',
    'LBL_CURRENT_USER_FILTER' => 'Nur meine Einträge:',
    'LBL_DATE_ENTERED' => 'Erstellt am:',
    'LBL_DATE_MODIFIED' => 'Geändert am:',
    'LBL_DELETE_BUTTON_KEY' => 'D',
    'LBL_DELETE_BUTTON_LABEL' => 'Löschen',
    'LBL_DELETE_BUTTON_TITLE' => 'Löschen [Alt+D]',
    'LBL_DELETE_BUTTON' => 'Löschen',
    'LBL_DELETE' => 'Löschen',
    'LBL_DELETED'=>'Gelöscht',
    'LBL_DIRECT_REPORTS'=>'Direkt-Unterstellte',
    'LBL_DONE_BUTTON_KEY' => 'X',
    'LBL_DONE_BUTTON_LABEL' => 'Fertig',
    'LBL_DONE_BUTTON_TITLE' => 'Fertig [Alt+X]',
    'LBL_DST_NEEDS_FIXIN' => 'Das Programm benötigt die Anwendung des Sommerzeit-Patches. Bitte klicken Sie auf den Reparaturlink im Admin-Bereich und wenden Sie den Sommerzeit Patch an.',
    'LBL_DUPLICATE_BUTTON_KEY' => 'U',
    'LBL_DUPLICATE_BUTTON_LABEL' => 'Duplizieren',
    'LBL_DUPLICATE_BUTTON_TITLE' => 'Duplizieren [Alt+U]',
    'LBL_DUPLICATE_BUTTON' => 'Duplizieren',
    'LBL_EDIT_BUTTON_KEY' => 'E',
    'LBL_EDIT_BUTTON_LABEL' => 'Bearbeiten',
    'LBL_EDIT_BUTTON_TITLE' => 'Bearbeiten [Alt+E]',
    'LBL_EDIT_BUTTON' => 'Bearbeiten',
    'LBL_VIEW_BUTTON_KEY' => 'V',
    'LBL_VIEW_BUTTON_LABEL' => 'Ansicht',
    'LBL_VIEW_BUTTON_TITLE' => 'Anzeigen [Alt+V]',
    'LBL_VIEW_BUTTON' => 'Ansicht',
    'LBL_EMAIL_PDF_BUTTON_KEY' => 'M',
    'LBL_EMAIL_PDF_BUTTON_LABEL' => 'E-Mail als PDF',
    'LBL_EMAIL_PDF_BUTTON_TITLE' => 'E-Mail als PDF [Alt+M]',
    'LBL_EMAILS'=>'E-Mails',
    'LBL_EMPLOYEES' => 'Mitarbeiter',
    'LBL_ENTER_DATE' => 'Datum eingeben',
    'LBL_EXPORT_ALL' => 'Alle exportieren',
    'LBL_EXPORT' => 'Exportieren',
    'LBL_GO_BUTTON_LABEL' => 'Start',
    'LBL_HIDE'=>'Ausblenden',
    'LBL_ID'=>'ID',
    'LBL_IMPORT_PROSPECTS'=>'Zielpersonen importieren',
    'LBL_IMPORT' => 'Import',
    'LBL_IMPORT_STARTED' => 'Import gestartet:',
    'LBL_MISSING_CUSTOM_DELIMITER' => 'Ein benutzerdefiniertes Trennzeichen muss angegeben werden.',
    'LBL_LAST_VIEWED' => 'Zuletzt angesehen',
    'LBL_LEADS'=>'Interessenten',
    'LBL_LESS' => 'weniger',
    'LBL_CAMPAIGN' => 'Kampagne:',
    'LBL_CAMPAIGN_ID'=>'campaign_id',
    'LBL_SITEMAP'=>'Sitemap',

    'LBL_LIST_ACCOUNT_NAME' => 'Firmenname',
    'LBL_LIST_ASSIGNED_USER' => 'Benutzer',
    'LBL_LIST_CONTACT_NAME' => 'Kontakt:',
    'LBL_LIST_CONTACT_ROLE' => 'Kontakt Rolle',
    'LBL_LIST_EMAIL' => 'E-Mail',
    'LBL_LIST_NAME' => 'Name',
    'LBL_LIST_OF' => 'von',
    'LBL_LIST_PHONE' => 'Telefon',
    'LBL_LIST_USER_NAME' => 'Benutzername',
    'LBL_LISTVIEW_MASS_UPDATE_CONFIRM' => 'Möchten Sie wirklich die gesamte Liste aktualisieren?',
    'LBL_LISTVIEW_NO_SELECTED' => 'Bitte mindestens 1 Datensatz auswählen um fortzufahren.',
    'LBL_LISTVIEW_TWO_REQUIRED' => 'Bitte wählen Sie mindestens 2 Datensätze aus um fortzufahren.',
    'LBL_LISTVIEW_ALL' => 'Alle',
    'LBL_LISTVIEW_NONE' => 'Kein(e)',
    'LBL_LISTVIEW_OPTION_CURRENT' => 'Diese Seite',
    'LBL_LISTVIEW_OPTION_ENTIRE' => 'Gesamte Liste',
    'LBL_LISTVIEW_OPTION_SELECTED' => 'Ausgewählte Datensätze',
    'LBL_LISTVIEW_SELECTED_OBJECTS' => 'Ausgewählt:',

    'LBL_LOCALE_NAME_EXAMPLE_FIRST' => 'Hans',
    'LBL_LOCALE_NAME_EXAMPLE_LAST' => 'Muster',
    'LBL_LOCALE_NAME_EXAMPLE_SALUTATION' => 'Hr.',
    'LBL_LOCALE_NAME_EXAMPLE_TITLE' => 'Vorstandsvorsitzender',
    'LBL_LOGOUT' => 'Abmelden',
    'LBL_MAILMERGE_KEY' => 'M',
    'LBL_MAILMERGE' => 'Serienbrief',
    'LBL_MASS_UPDATE' => 'Massenänderung',
    'LBL_MEETINGS'=>'Meetings',
    'LBL_MEETING'=>'Meeting',
    'LBL_MEMBERS'=>'Mitglieder',
    'LBL_MODIFIED_BY_USER'=>'Geändert von',
    'LBL_MODIFIED' => 'Geändert von',
    'LBL_MORE' => 'mehr',
    'LBL_MY_ACCOUNT' => 'Mein Konto',
    'LBL_NAME' => 'Name',
    'LBL_NEW_BUTTON_KEY' => 'N',
    'LBL_NEW_BUTTON_LABEL' => 'Erstellen',
    'LBL_NEW_BUTTON_TITLE' => 'Neu [Alt+N]',
    'LBL_NEXT_BUTTON_LABEL' => 'Weiter',
    'LBL_NONE' => '--Kein(e)--',
    'LBL_NOTES'=>'Notizen',
    'LBL_OPENALL_BUTTON_KEY' => 'O',
    'LBL_OPENALL_BUTTON_LABEL' => 'Alle öffnen',
    'LBL_OPENALL_BUTTON_TITLE' => 'Alle öffnen [Alt+O]',
    'LBL_OPENTO_BUTTON_KEY' => 'T',
    'LBL_OPENTO_BUTTON_LABEL' => 'Öffnen zu:',
    'LBL_OPENTO_BUTTON_TITLE' => 'Öffnen zu: [Alt+T]',
    'LBL_OPPORTUNITIES'=>'Verkaufschancen',
    'LBL_OPPORTUNITY_NAME' => 'Verkaufschance Name',
    'LBL_OPPORTUNITY'=>'Verkaufschance',
    'LBL_OR' => 'oder',
    'LBL_PERCENTAGE_SYMBOL' => '%',
    'LBL_POSTAL_CODE' => 'PLZ:',
    'LBL_PRIMARY_ADDRESS_CITY' => 'Hauptadresse Stadt:',
    'LBL_PRIMARY_ADDRESS_COUNTRY' => 'Hauptadresse Land:',
    'LBL_PRIMARY_ADDRESS_POSTALCODE' => 'Hauptadresse PLZ:',
    'LBL_PRIMARY_ADDRESS_STATE' => 'Hauptadresse Bundesland:',
    'LBL_PRIMARY_ADDRESS_STREET_2' => 'Hauptadresse Strasse 2:',
    'LBL_PRIMARY_ADDRESS_STREET_3' => 'Hauptadresse Strasse 3:',
    'LBL_PRIMARY_ADDRESS_STREET' => 'Hauptadresse Strasse:',
    'LBL_PRIMARY_ADDRESS' => 'Hauptadresse:',
    'LBL_PRODUCT_BUNDLES'=>'Produkpakete',
    'LBL_PRODUCT_BUNDLES'=>'Produkpakete',
    'LBL_PRODUCTS'=>'Produkte',
    'LBL_PROJECT_TASKS'=>'Projektaufgaben',
    'LBL_PROJECTS'=>'Projekte',
    'LBL_PROJECTS'=>'Projekte',
    'LBL_QUOTE_TO_OPPORTUNITY_KEY' => 'O',
    'LBL_QUOTE_TO_OPPORTUNITY_LABEL' => 'Verkaufschance aus Angebot erstellen',
    'LBL_QUOTE_TO_OPPORTUNITY_TITLE' => 'Verkaufschance aus Angebot erstellen [Alt+O]',
    'LBL_QUOTES_SHIP_TO'=>'Angebote liefern an',
    'LBL_QUOTES'=>'Angebote',
    'LBL_RELATED_RECORDS' => 'Verknüpfte Einträge',
    'LBL_REMOVE' => 'Entfernen',
    'LBL_REQUIRED_SYMBOL' => '*',
    'LBL_SAVE_BUTTON_KEY' => 'S',
    'LBL_SAVE_BUTTON_LABEL' => 'Speichern',
    'LBL_SAVE_BUTTON_TITLE' => 'Speichern [Alt+S]',
    'LBL_SAVE_AS_BUTTON_KEY' => 'A',
    'LBL_SAVE_AS_BUTTON_LABEL' => 'Speichern unter',
    'LBL_SAVE_AS_BUTTON_TITLE' => 'Speichern unter [Alt+A]',
    'LBL_FULL_FORM_BUTTON_KEY' => 'F',
    'LBL_FULL_FORM_BUTTON_LABEL' => 'Komplettes Formular',
    'LBL_FULL_FORM_BUTTON_TITLE' => 'Komplettes Formular [Alt+F]',
    'LBL_SAVE_NEW_BUTTON_KEY' => 'V',
    'LBL_SAVE_NEW_BUTTON_LABEL' => 'Speichern & neuen erzeugen',
    'LBL_SAVE_NEW_BUTTON_TITLE' => 'Speichern & neuen erzeugen [Alt+V]',
    'LBL_SEARCH_BUTTON_KEY' => 'Q',
    'LBL_SEARCH_BUTTON_LABEL' => 'Suchen',
    'LBL_SEARCH_BUTTON_TITLE' => 'Suchen [Alt+Q]',
    'LBL_SEARCH' => 'Suchen',
    'LBL_SELECT_BUTTON_KEY' => 'T',
    'LBL_SELECT_BUTTON_LABEL' => 'Auswählen',
    'LBL_SELECT_BUTTON_TITLE' => 'Auswählen [Alt+T]',
    'LBL_BROWSE_DOCUMENTS_BUTTON_KEY' => 'B',
    'LBL_BROWSE_DOCUMENTS_BUTTON_LABEL' => 'Dokumente durchsuchen',
    'LBL_BROWSE_DOCUMENTS_BUTTON_TITLE' => 'Dokumente durchsuchen [Alt+B]',
    'LBL_SELECT_CONTACT_BUTTON_KEY' => 'T',
    'LBL_SELECT_CONTACT_BUTTON_LABEL' => 'Kontakt auswählen',
    'LBL_SELECT_CONTACT_BUTTON_TITLE' => 'Kontakt auswählen [Alt+T]',
    'LBL_GRID_SELECTED_FILE' => 'gewählte Datei',
    'LBL_GRID_SELECTED_FILES' => 'gewählte Dateien',
    'LBL_SELECT_REPORTS_BUTTON_LABEL' => 'Aus Bericht wählen',
    'LBL_SELECT_REPORTS_BUTTON_TITLE' => 'Berichte auswählen',
    'LBL_SELECT_USER_BUTTON_KEY' => 'U',
    'LBL_SELECT_USER_BUTTON_LABEL' => 'Benutzer auswählen',
    'LBL_SELECT_USER_BUTTON_TITLE' => 'Benutzer auswählen [Alt+U]',
    'LBL_SERVER_RESPONSE_RESOURCES' => 'Ressourcen zum Aufbau dieser Seite (Abfragen, Dateien)',
    'LBL_SERVER_RESPONSE_TIME_SECONDS' => 'Sekunden.',
    'LBL_SERVER_RESPONSE_TIME' => 'Server Antwortzeit:',
    'LBL_SHIP_TO_ACCOUNT'=>'Liefern an Firma',
    'LBL_SHIP_TO_CONTACT'=>'Liefern an Kontaktperson',
    'LBL_SHIPPING_ADDRESS'=>'Lieferadresse',
    'LBL_SHORTCUTS' => 'Schnellmenü',
    'LBL_SHOW'=>'Zeigen',
    'LBL_SQS_INDICATOR' => '',
    'LBL_STATE' => 'Bundesland:',
    'LBL_STATUS_UPDATED'=>'Der Status für dieses Ereignis wurde aktualisiert!',
    'LBL_STATUS'=>'Status:',
    'LBL_SUBJECT' => 'Betreff',





    // The following version of LBL_SUGAR_COPYRIGHT is for Professional and Enterprise editions.
    'LBL_SUGAR_COPYRIGHT' => '© 2004-2008 <a href="http://www.sugarcrm.com" target="_blank" class="copyRightLink">SugarCRM Inc.</a> All Rights Reserved.',

    'LBL_SYNC' => 'Sync',
    'LBL_SYNC' => 'Sync',
    'LBL_TABGROUP_ALL' => 'Alle',
    'LBL_TABGROUP_ACTIVITIES' => 'Aktivitäten',
    'LBL_TABGROUP_COLLABORATION' => 'Zusammenarbeit',
    'LBL_TABGROUP_HOME' => 'Home',
    'LBL_TABGROUP_MARKETING' => 'Marketing',
    'LBL_TABGROUP_MY_PORTALS' => 'Meine Portale',
    'LBL_TABGROUP_OTHER' => 'Andere',
    'LBL_TABGROUP_REPORTS' => 'Berichte',
    'LBL_TABGROUP_SALES' => 'Verkauf',
    'LBL_TABGROUP_SUPPORT' => 'Support',
    'LBL_TABGROUP_TOOLS' => 'Werkzeuge',
    'LBL_TASKS'=>'Aufgaben',
    'LBL_TEAMS_LINK'=>'Team',
    'LBL_THOUSANDS_SYMBOL' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_KEY' => 'K',
    'LBL_TRACK_EMAIL_BUTTON_LABEL' => 'E-Mail archivieren',
    'LBL_TRACK_EMAIL_BUTTON_TITLE' => 'E-Mail archivieren [Alt+K]',
    'LBL_UNAUTH_ADMIN' => 'Unautorisierter Zugriff auf Administration',
    'LBL_UNDELETE_BUTTON_LABEL' => 'Rückgängig',
    'LBL_UNDELETE_BUTTON_TITLE' => 'Rückgängig [Alt+D]',
    'LBL_UNDELETE_BUTTON' => 'Rückgängig',
    'LBL_UNDELETE' => 'Rückgängig',
    'LBL_UNSYNC' => 'Unsync',
    'LBL_UPDATE' => 'Aktualisieren',
    'LBL_USER_LIST' => 'Benutzer Liste',
    'LBL_USERS_SYNC'=>'Benutzer Sync',
    'LBL_USERS'=>'Benutzer',
    'LBL_VIEW_PDF_BUTTON_KEY' => 'P',
    'LBL_VIEW_PDF_BUTTON_LABEL' => 'Als PDF drucken',
    'LBL_VIEW_PDF_BUTTON_TITLE' => 'Als PDF drucken [Alt+P]',

    'LNK_ABOUT' => 'Über',
    'LNK_ADVANCED_SEARCH' => 'Erweiterte Suche',
    'LNK_BASIC_SEARCH' => 'Einfache Suche',
    'LNK_SAVED_VIEWS' => 'Gespeicherte Suche & Layout',
    'LNK_DELETE_ALL' => 'alles löschen',
    'LNK_DELETE' => 'löschen',
    'LNK_EDIT' => 'bearb.',
    'LNK_GET_LATEST'=>'Letzte anzeigen',
    'LNK_GET_LATEST_TOOLTIP'=>'Ersetzen mit letzter Version',
    'LNK_HELP' => 'Hilfe',
    'LNK_LIST_END' => 'Ende',
    'LNK_LIST_NEXT' => 'Weiter',
    'LNK_LIST_PREVIOUS' => 'Zurück',
    'LNK_LIST_RETURN' => 'Zurück zur Liste',
    'LNK_LIST_START' => 'Start',
    'LNK_LOAD_SIGNED'=>'Unterschreiben',
    'LNK_LOAD_SIGNED_TOOLTIP'=>'Ersetzen durch signiertes Dokument',
    'LNK_PRINT' => 'Drucken',
    'LNK_REMOVE' => 'entf.',
    'LNK_RESUME' => 'Fortsetzen',
    'LNK_VIEW_CHANGE_LOG' => 'Änderungslog zeigen',


    'NTC_CLICK_BACK' => 'Bitte den Zurück-Button des Browsers anklicken und den Fehler beheben.',
    'NTC_DATE_FORMAT' => '(jjjj-mm-tt)',
    'NTC_DATE_TIME_FORMAT' => '(jjjj-mm-tt 24:00)',
    'NTC_DELETE_CONFIRMATION_MULTIPLE' => 'Möchten Sie die ausgewählten Einträge wirklich löschen?',
    'NTC_DELETE_CONFIRMATION' => 'Sind Sie sicher, dass Sie diesen Eintrag löschen wollen?',
    'NTC_DELETE_CONFIRMATION_NUM' => 'Wollen Sie wirklich löschen?',
    'NTC_UPDATE_CONFIRMATION_NUM' => 'Wollen Sie wirklich aktualisieren? ',
    'NTC_DELETE_SELECTED_RECORDS' =>' ausgewählte Datensätze',
    'NTC_LOGIN_MESSAGE' => 'Bitte geben Sie Ihren Benutzernamen und Passwort ein.',
    'NTC_NO_ITEMS_DISPLAY' => 'Keine Einträge vorhanden',
    'NTC_REMOVE_CONFIRMATION' => 'Möchten Sie diese Beziehung wirklich entfernen?',
    'NTC_REQUIRED' => 'Pflichtfeld',
    'NTC_SUPPORT_SUGARCRM' => 'Unterstützen Sie das SugarCRM Open Source Projekt mit einer Spende über PayPal - schnell, gratis und sicher!',
    'NTC_TIME_FORMAT' => '(24:00)',
    'NTC_WELCOME' => 'Willkommen',
    'NTC_YEAR_FORMAT' => '(jjjj)',
    'LOGIN_LOGO_ERROR'=> 'Bitte die SugarCRM Logos ersetzen',
    'ERROR_FULLY_EXPIRED'=> "Die Lizenz Ihrer SugarCRM Installation ist seit über 30 Tagen abgelaufen und muss aktualisiert werden. Es können leider nur Administratoren einloggen.",
    'ERROR_LICENSE_EXPIRED'=> "Die Lizenz Ihrer SugarCRM Installation muss aktualisiert werden. Es können leider nur Administratoren einloggen.",
    'ERROR_LICENSE_VALIDATION'=> "Ihre Lizenz für SugarCRM muss validiert werden. Nur Administratoren können sich anmelden.",
    'ERROR_NO_RECORD' => 'Fehler beim Laden des Datensatzes. Dieser Datensatz wurde entweder gelöscht oder Sie sind nicht berechtigt ihn zu sehen.',
    'LBL_DUP_MERGE'=>'Dubletten finden',
    'LBL_MANAGE_SUBSCRIPTIONS'=>'Abonnements verwalten',
    'LBL_MANAGE_SUBSCRIPTIONS_FOR'=>'Abonnements verwalten für',
    'LBL_SUBSCRIBE'=>'Anmelden',
    'LBL_UNSUBSCRIBE'=>'Abmelden',
    // Ajax status strings
    'LBL_LOADING' => 'Laden...',
    'LBL_SAVING_LAYOUT' => 'Layout wird gespeichert...',
    'LBL_SAVED_LAYOUT' => 'Layout wurde gespeichert.',
    'LBL_SAVED' => 'Gespeichert.',
    'LBL_SAVING' => 'Speichern',
    'LBL_FAILED' => 'Fehlgeschlagen!',
    'LBL_DISPLAY_COLUMNS' => 'Spalten anzeigen',
    'LBL_HIDE_COLUMNS' => 'Spalten ausblenden',
    'LBL_SEARCH_CRITERIA' => 'Suchkriterien',
    'LBL_SAVED_VIEWS' => 'Gespeicherte Ansichten',
    'LBL_PROCESSING_REQUEST'=>'Verarbeitung...',
    'LBL_REQUEST_PROCESSED'=>'Fertig',

    'LBL_OC_STATUS' => 'Offline Client Status',
    'LBL_OC_STATUS_TEXT' => 'Zeigt an, ob der derzeitige Benutzer einen Offline Client verwenden kann.',
    'LBL_OC_DEFAULT_STATUS' => 'Inaktiv',

    'LBL_MERGE_DUPLICATES'  => 'Dubletten zusammenführen',
    'LBL_SAVED_SEARCH_SHORTCUT' => 'Gespeicherte Suche',
    'LBL_SEARCH_POPULATE_ONLY'=> 'Mit dem obigen Suchformular suchen',
    'LBL_DETAILVIEW'=>'Detailansicht',
    'LBL_LISTVIEW'=>'Listenansicht',
    'LBL_EDITVIEW'=>'Bearbeitungsansicht',
    'LBL_SEARCHFORM'=>'Suchformular',
    'LBL_SAVED_SEARCH_ERROR' => 'Bitte geben Sie einen Namen für diese Ansicht ein.',
    'LBL_DISPLAY_LOG' => 'Log anzeigen',
    'ERROR_JS_ALERT_SYSTEM_CLASS' => 'System',
    'ERROR_JS_ALERT_TIMEOUT_TITLE' => 'Session Timeout',
    'ERROR_JS_ALERT_TIMEOUT_MSG_1' => 'Ihre Session läuft in 2 Minuten ab. Bitte speichern Sie Ihre Arbeit.',
    'ERROR_JS_ALERT_TIMEOUT_MSG_2' =>'Ihre Session ist abgelaufen.',
    'MSG_JS_ALERT_MTG_REMINDER_AGENDA' => "\nAgenda: ",
    'MSG_JS_ALERT_MTG_REMINDER_MEETING' => 'Meeting',
    'MSG_JS_ALERT_MTG_REMINDER_CALL' => 'Anruf',
    'MSG_JS_ALERT_MTG_REMINDER_TIME' => 'Zeit:',
    'MSG_JS_ALERT_MTG_REMINDER_LOC' => 'Ort:',
    'MSG_JS_ALERT_MTG_REMINDER_DESC' => 'Beschreibung:',
    'MSG_JS_ALERT_MTG_REMINDER_MSG' => "\nKlicken Sie auf OK um sich das Meeting anzusehen oder auf Abbrechen.",
    // contextMenu strings
    'LBL_ADD_TO_FAVORITES' => 'Zu meinen Favoriten hinzufügen',
    'LBL_CREATE_CONTACT' => 'Neuer Kontakt',
    'LBL_CREATE_CASE' => 'Neuer Fall',
    'LBL_CREATE_NOTE' => 'Neue Notiz',
    'LBL_CREATE_OPPORTUNITY' => 'Neue Verkaufschance',
    'LBL_SCHEDULE_CALL' => 'Neuer Anruf',
    'LBL_SCHEDULE_MEETING' => 'Neues Meeting',
    'LBL_CREATE_TASK' => 'Neue Aufgabe',
    'LBL_REMOVE_FROM_FAVORITES' => 'Aus Favoriten entfernen',
    //web to lead
    'LBL_GENERATE_WEB_TO_LEAD_FORM' => 'Formular erstellen',
    'LBL_SAVE_WEB_TO_LEAD_FORM' =>'Web-2-Lead Formular speichern',

    'LBL_PLEASE_SELECT' => 'Bitte auswählen',
    'LBL_REDIRECT_URL'=>'Weiterleitungs-URL',
    'LBL_RELATED_CAMPAIGN' =>'Verknüpfte Kampagne',
    'LBL_ADD_ALL_LEAD_FIELDS' => 'Alle Felder hinzufügen',
    'LBL_REMOVE_ALL_LEAD_FIELDS' => 'Alle Felder entfernen',
    'LBL_ONLY_IMAGE_ATTACHMENT' => 'Nur Bilder können eingefügt werden',
    'LBL_REMOVE' => 'Entfernen',
    'LBL_TRAINING' => 'Training',
    'ERR_DATABASE_CONN_DROPPED'=>'SQL Abfrage Fehler. Wahrscheinlich ist die Datenbankverbindung unterbrochen. Bitte die Seite erneut aufrufen, möglicherweise muss der Webserver neu gestartet werden.',
    'ERR_MSSQL_DB_CONTEXT' =>'DB Kontext geändert auf',

    //Meta-Data framework
    'ERR_MISSING_VARDEF_NAME' => 'Warnung: Feld [[field]] hat keinen Eintrag in der [moduleDir] vardefs.php Datei',
    'ERR_CANNOT_CREATE_METADATA_FILE' => 'Fehler: Datei [[file]] fehlt.  Kann nichts erstellen da keine korrespondierende HTML Datei gefunden wurde',
    'LBL_ALT_ADDRESS' => 'Weitere Adresse:',
    'ERR_SMARTY_UNEQUAL_RELATED_FIELD_PARAMETERS' => 'Fehler: Es gibt eine ungleiche Anzahl von \'key\' and \'copy\' Elementen im displayParams Array.',
    'ERR_SMARTY_MISSING_DISPLAY_PARAMS' => 'Fehlender Index in displayParams Array für:',

    /* MySugar Framework (for Home and Dashboard) */
    'LBL_DASHLET_CONFIGURE_GENERAL' => 'Allgemein',
    'LBL_DASHLET_CONFIGURE_FILTERS' => 'Filter',
    'LBL_DASHLET_CONFIGURE_MY_ITEMS_ONLY' => 'Nur meine Einträge',
    'LBL_DASHLET_CONFIGURE_TITLE' => 'Titel',
    'LBL_DASHLET_CONFIGURE_DISPLAY_ROWS' => 'Zeilen zeigen',

    // MySugar status strings
    'LBL_CREATING_NEW_PAGE' => 'Neue Seite erstellen...',
    'LBL_NEW_PAGE_FEEDBACK' => 'Sie haben eine neue Seite erstellt. Sie können nun mit der \'Dashlet hinzufügen\' Menü Option neue Inhalte einfügen.',
    'LBL_DELETE_PAGE_CONFIRM' => 'Wollen Sie diese Seite wirklich löschen?',
    'LBL_SAVING_PAGE_TITLE' => 'Seitentitel wird gespeichert ...',
    'LBL_RETRIEVING_PAGE' => 'Seite laden ...',
    'LBL_MAX_DASHLETS_REACHED' => 'Sie können keine weiteren Dashlets hinzufügen. Bitte ein Dashlet entfernen, um weitere hinzuzufügen.',
    'LBL_ADDING_DASHLET' => 'Dashlet wird hinzugefügt ...',
    'LBL_ADDED_DASHLET' => 'Dashlet hinzugefügt',
    'LBL_REMOVE_DASHLET_CONFIRM' => 'Wollen Sie dieses Dashlet wirklich löschen?',
    'LBL_REMOVING_DASHLET' => 'Dashlet wird entfernt ...',
    'LBL_REMOVED_DASHLET' => 'Dashlet entfernt',

    // MySugar Menu Options
    'LBL_ADD_PAGE' => 'Seite hinzufügen',
    'LBL_DELETE_PAGE' => 'Seite löschen',
    'LBL_CHANGE_LAYOUT' => 'Ansicht ändern',
    'LBL_RENAME_PAGE' => 'Seite umbennenen',

    'LBL_LOADING_PAGE' => 'Seite wird geladen, bitte warten...',

    'LBL_RELOAD_PAGE' => 'Bitte <a href="javascript: window.location.reload()">das Fenster neu laden</a> um dieses Dashlet zu verwenden.',
    'LBL_ADD_DASHLETS' => 'Dashlets hinzufügen',
    'LBL_CLOSE_DASHLETS' => 'Schließen',
    'LBL_OPTIONS' => 'Optionen',
    'LBL_NUMBER_OF_COLUMNS' => 'Klicken Sie auf ein Icon, um die Anzahl Spalten zu wählen',
    'LBL_1_COLUMN' => '1. Spalte',
    'LBL_2_COLUMN' => '2. Spalte',
    'LBL_3_COLUMN' => '3. Spalte',
    'LBL_PAGE_NAME' => 'Seitenname',

    'LBL_SEARCH_RESULTS' => 'Suchergebnisse',
    'LBL_SEARCH_MODULES' => 'Module',
    'LBL_SEARCH_CHARTS' => 'Diagramme',
    'LBL_SEARCH_REPORT_CHARTS' => 'Bericht Diagramme',
    'LBL_SEARCH_TOOLS' => 'Werkzeuge',

    'ERR_BLANK_PAGE_NAME' => 'Bitte einen Seitennamen eintragen.',
    /* End MySugar Framework strings */

    'LBL_NO_IMAGE' => 'Kein Bild',

    //adding a label for address copy from left
    'LBL_COPY_ADDRESS_FROM_LEFT' => 'Adresse von links kopieren:',
    'LBL_SAVE_AND_CONTINUE' => 'Speichern und weiter',

    'LBL_SEARCH_HELP_TEXT' => '<p><br /><strong>Multiselect Steuerungen</p><ul><li>Klicken Sie auf die Werte um ein Attribut auszuwählen.</li><li>STRG-Klick um mehrere auszuwählen. Mac Benutzer verwenden CMD-Klick.</li><li>Um alle Werte zwischen zwei Attributen auszuwählen, klicken Sie zuerst auf den ersten Wert und dann mit UMSCH-Klick auf den zweiten.</li></ul><p><strong>Erweiterte Suche und Layout Optionen</strong><br><br>Wenn Sie die <b>Gespeicherte Suche & Layout</b> Option verwenden, können Sie eine vordefinierte Suche bzw. eine angepasste Listenansicht speichern, um später schnell zu den gewünschten Ergebnissen zu kommen. Sie können eine unbegrenzet Anzahl solcher Selektionen speichern. Alle gespeicherten Selektionen scheinen in der \'Gespeicherte Suche\' Liste mit Namen auf, wobei die aktuell geladene Suche an der Spitze steht.<br><br>Um die Listenansicht anzupassen, verwenden Sie die \'Spalten anzeigen\' bzw. \'Spalten verstecken\' Kästchen. Sie können zum Beispiel Angaben wie Teams, zugewiesener Benutzer oder Datensatzname verbergen oder anzeigen. Um eine Spalte zur Listenansicht hinzuzufügen, wählen Sie das Feld aus der Liste der verborgenen Spalten und bewegen es mit der linken Pfeiltaste in die Spalte der angezeigten Begriffe. Um eine Spalte aus der Listenansicht zu entfernen, verfahren Sie genau umgekehrt.<br><br>Wenn Sie die Layout Einstellungen speichern, können Sie Ihre Suchergebnisse später immer in diesem Layout ausgeben.<br><br>Um eine Suche bzw. ein Layout zu speichern:<ol><li>Geben Sie einen Namen für das Suchresultat unter <b>Suche speichern unter</b> Feld ein und klicken Sie auf <b>Speichern</b>. Der Name wird nun in der Gespeicherten Suche Liste angezeigt, direkt neben der  Schaltfläche <b>Leeren</b>.</li><li>Um eine gespeicherte Suche aufzurufen, wählen Sie sie aus der Liste aus. Die Suchergebnisse werden in der Listenansicht dargestellt.</li><li>Um eine Gespeicherte Suche zu ändern wählen Sie die Suche aus der Liste aus, ändern die entsprechenden Such- und/oder Darstellungsparameter und klicken auf <b>Aktualisieren</b> neben <b>Aktuelle Suche ändern</b>.</li><li>Um eine Gespeicherte Suche zu löschen, wählen Sie die Suche aus der Liste aus, klicken <b>Löschen</b> neben <b>Aktuelle Suche ändern</b>, und klicken dann auf <b>OK</b> um das Löschen zu bestätigen.</li></ol>' ,
);

$app_list_strings['moduleList']['Library'] = 'Library';
$app_list_strings['library_type'] = array('Books'=>'B', 'Music'=>'Musik', 'DVD'=>'DVD', 'Magazines'=>'Magazines');
$app_list_strings['moduleList']['EmailAddresses'] = 'Email Address';

$app_list_strings['kbdocument_status_dom'] = 'Draft';
$app_list_strings['kbdocument_status_dom'] = array (
    'Draft' => 'Entwurf',
    'In Review' => 'In Durchsicht',
    'Published' => 'Veröffentlicht',
);

$app_list_strings['project_priority_default'] = 'Medium';
$app_list_strings['project_priority_options'] = array (
    'High' => 'Hoch',
    'Medium' => 'Mittel',
    'Low' => 'Niedrig',
);


  $app_list_strings['kbdocument_status_dom'] =
    array (
    'Draft' => 'Entwurf',
    'Expired' => 'Abgelaufen',
    'In Review' => 'In Durchsicht',
    'Published' => 'Veröffentlicht',
  );

   $app_list_strings['kbadmin_actions_dom'] =
    array (
    ''          => '--Admin Aktionen--',
    'Create New Tag' => 'Neuen Tag erstellen',
    'Delete Tag'=>'Tag löschen',
    'Rename Tag'=>'Tag umbenennen',
    'Move Selected Articles'=>'Ausgewählte Artikel bewegen',
    'Apply Tags On Articles'=>'Tags auf Artikel anwenden',
    'Delete Selected Articles'=>'Ausgewählte Artikel löschen',
  );


  $app_list_strings['kbdocument_attachment_option_dom'] =
    array(
        ''=>'',
        'some' => 'Hat Anhänge',
        'none' => 'Hat Keine',
        'mime' => 'Mime Typ angeben',
        'name' => 'Name angeben',
    );

  $app_list_strings['moduleList']['KBDocuments'] = 'Knowledge Base';
  $app_strings['LBL_CREATE_KB_DOCUMENT'] = 'Create Article';
  $app_list_strings['kbdocument_viewing_frequency_dom'] =
  array(
    ''=>'',
    'Top_5'  => 'Ersten 5',
    'Top_10' => 'Ersten 10',
    'Top_20' => 'Ersten 20',
    'Bot_5'  => 'Letzten 5',
    'Bot_10' => 'Letzten 10',
    'Bot_20' => 'Letzten 20',
  );

   $app_list_strings['kbdocument_canned_search'] =
    array(
        'all'=>'Alle',
        'added' => 'Letzten 30 Tage hinzugefügt',
        'pending' => 'Vorbehaltlich meiner Genehmigung',
        'updated' =>'Letzten 30 Tage aktualisiert',
        'faqs' => 'FAQs',
    );
    $app_list_strings['kbdocument_date_filter_options'] =
        array(
    '' => '',
    'on' => 'Am',
    'before' => 'vor',
    'after' => 'nach',
    'between_dates' => 'ist zwischen',
    'last_7_days' => 'Letzten 7 Tage',
    'next_7_days' => 'Nächsten 7 Tage',
    'last_month' => 'Letzten Monat',
    'this_month' => 'Diesen Monat',
    'next_month' => 'Nächster Monat',
    'last_30_days' => 'Letzten 30 Tage',
    'next_30_days' => 'Nächsten 30 Tage',
    'last_year' => 'Letztes Jahr',
    'this_year' => 'Dieses Jahr',
    'next_year' => 'Nächstes Jahr',
    'isnull' => 'Ist Null',
        );

	$app_list_strings['countries_dom'] = array(
		'' => '',
		'ABU DHABI' => 'ABU DHABI',
		'ADEN' => 'ADEN',
		'AFGHANISTAN' => 'AFGHANISTAN',
		'ALBANIA' => 'ALBANIEN',
		'ALGERIA' => 'ALGERIEN',
		'AMERICAN SAMOA' => 'AMERICAN SAMOA',
		'ANDORRA' => 'ANDORRA',
		'ANGOLA' => 'ANGOLA',
		'ANTARCTICA' => 'ANTARKTIS',
		'ANTIGUA' => 'ANTIGUA',
		'ARGENTINA' => 'ARGENTINIEN',
		'ARMENIA' => 'ARMENIEN',
		'ARUBA' => 'ARUBA',
		'AUSTRALIA' => 'AUSTRALIEN',
		'AUSTRIA' => 'ÖSTERREICH',
		'AZERBAIJAN' => 'ASERBAIDSCHAN',
		'BAHAMAS' => 'BAHAMAS',
		'BAHRAIN' => 'BAHRAIN',
		'BANGLADESH' => 'BANGLADESH',
		'BARBADOS' => 'BARBADOS',
		'BELARUS' => 'WEISSRUSSLAND',
		'BELGIUM' => 'BELGIEN',
		'BELIZE' => 'BELIZE',
		'BENIN' => 'BENIN',
		'BERMUDA' => 'BERMUDA',
		'BHUTAN' => 'BHUTAN',
		'BOLIVIA' => 'BOLIVIEN',
		'BOSNIA' => 'BOSNIEM',
		'BOTSWANA' => 'BOTSWANA',
		'BOUVET ISLAND' => 'BOUVET ISLAND',
		'BRAZIL' => 'BRASILIEN',
		'BRITISH ANTARCTICA TERRITORY' => 'BRITISH TERRITORIEN ANTARKTIS',
		'BRITISH INDIAN OCEAN TERRITORY' => 'BRITISH TERRITORIEN IM INDISCHEN OZEAN',
		'BRITISH VIRGIN ISLANDS' => 'BRITISH VIRGIN INSELN',
		'BRITISH WEST INDIES' => 'BRITISH WEST INDIES',
		'BRUNEI' => 'BRUNEI',
		'BULGARIA' => 'BULGARIEN',
		'BURKINA FASO' => 'BURKINA FASO',
		'BURUNDI' => 'BURUNDI',
		'CAMBODIA' => 'KAMBODSCHA',
		'CAMEROON' => 'KAMERUN',
		'CANADA' => 'KANADA',
		'CANAL ZONE' => 'CANAL ZONE',
		'CANARY ISLAND' => 'KANARISCHE INSELN',
		'CAPE VERDI ISLANDS' => 'KAPVERDISCHEN INSELN',
		'CAYMAN ISLANDS' => 'CAYMAN INSELN',
		'CEVLON' => 'CEVLON',
		'CHAD' => 'CHAD',
		'CHANNEL ISLAND UK' => 'KANALINSELN UK',
		'CHILE' => 'CHILE',
		'CHINA' => 'CHINA',
		'CHRISTMAS ISLAND' => 'CHRISTMAS INSELN',
		'COCOS (KEELING) ISLAND' => 'COCOS (KEELING) INSEL',
		'COLOMBIA' => 'KOLUMBIEN',
		'COMORO ISLANDS' => 'COMORO INSELN',
		'CONGO' => 'KONGO',
		'CONGO KINSHASA' => 'KONGO KINSHASA',
		'COOK ISLANDS' => 'COOK INSELN',
		'COSTA RICA' => 'COSTA RICA',
		'CROATIA' => 'KROATIEN',
		'CUBA' => 'KUBA',
		'CURACAO' => 'CURACAO',
		'CYPRUS' => 'ZYPERN',
		'CZECH REPUBLIC' => 'TSCHECHISCHE REPUBLIK',
		'DAHOMEY' => 'DAHOMEY',
		'DENMARK' => 'DÄNEMARK',
		'DJIBOUTI' => 'DJIBOUTI',
		'DOMINICA' => 'DOMINICA',
		'DOMINICAN REPUBLIC' => 'DOMINIKANISCHE REPUBLIK',
		'DUBAI' => 'DUBAI',
		'ECUADOR' => 'ECUADOR',
		'EGYPT' => 'ÄGYPTEN',
		'EL SALVADOR' => 'EL SALVADOR',
		'EQUATORIAL GUINEA' => 'ÄQUATORIAL GUINEA',
		'ESTONIA' => 'ESTLAND',
		'ETHIOPIA' => 'ÄTHIOPIEN',
		'FAEROE ISLANDS' => 'FÄRÖER INSEL',
		'FALKLAND ISLANDS' => 'FALKLAND INSELN',
		'FIJI' => 'FIDSCHI',
		'FINLAND' => 'FINNLAND',
		'FRANCE' => 'FRANKREICH',
		'FRENCH GUIANA' => 'FRANZÖSISCH GUIANA',
		'FRENCH POLYNESIA' => 'FRANZÖSISCH POLYNESIEN',
		'GABON' => 'GABON',
		'GAMBIA' => 'GAMBIA',
		'GEORGIA' => 'GEORGIEN',
		'GERMANY' => 'DEUTSCHLAND',
		'GHANA' => 'GHANA',
		'GIBRALTAR' => 'GIBRALTAR',
		'GREECE' => 'GRIECHENLAND',
		'GREENLAND' => 'GRÖNLAND',
		'GUADELOUPE' => 'GUADELOUPE',
		'GUAM' => 'GUAM',
		'GUATEMALA' => 'GUATEMALA',
		'GUINEA' => 'GUINEA',
		'GUYANA' => 'GUYANA',
		'HAITI' => 'HAITI',
		'HONDURAS' => 'HONDURAS',
		'HONG KONG' => 'HONG KONG',
		'HUNGARY' => 'UNGARN',
		'ICELAND' => 'ISLAND',
		'IFNI' => 'IFNI',
		'INDIA' => 'INDIEN',
		'INDONESIA' => 'INDONESIEN',
		'IRAN' => 'IRAN',
		'IRAQ' => 'IRAK',
		'IRELAND' => 'IRLAND',
		'ISRAEL' => 'ISRAEL',
		'ITALY' => 'ITALIEN',
		'IVORY COAST' => 'ELFENBEINKÜSTE',
		'JAMAICA' => 'JAMAIKA',
		'JAPAN' => 'JAPAN',
		'JORDAN' => 'JORDANIEN',
		'KAZAKHSTAN' => 'KASACHSTAN',
		'KENYA' => 'KENIA',
		'KOREA' => 'KOREA',
		'KOREA, SOUTH' => 'SÜD KOREA',
		'KUWAIT' => 'KUWAIT',
		'KYRGYZSTAN' => 'KIRGISIEN',
		'LAOS' => 'LAOTISCHE REPUBLIK',
		'LATVIA' => 'LETTLAND',
		'LEBANON' => 'LIBANON',
		'LEEWARD ISLANDS' => 'LEEWARD INSELN',
		'LESOTHO' => 'LESOTHO',
		'LIBYA' => 'LIBERIA',
		'LIECHTENSTEIN' => 'LIECHTENSTEIN',
		'LITHUANIA' => 'LETTLAND',
		'LUXEMBOURG' => 'LUXEMBURG',
		'MACAO' => 'MACAU',
		'MACEDONIA' => 'MAZEDONIEN',
		'MADAGASCAR' => 'MADAGASKAR',
		'MALAWI' => 'MALAWI',
		'MALAYSIA' => 'MALAYSIEN',
		'MALDIVES' => 'MALEDIVEN',
		'MALI' => 'MALI',
		'MALTA' => 'MALTA',
		'MARTINIQUE' => 'MARTINIQUE',
		'MAURITANIA' => 'MAURITANIEN',
		'MAURITIUS' => 'MAURITIUS',
		'MELANESIA' => 'MELANESIA',
		'MEXICO' => 'MEXIKO',
		'MOLDOVIA' => 'MOLDAWIEN',
		'MONACO' => 'MONACO',
		'MONGOLIA' => 'MONGOLEI',
		'MOROCCO' => 'MAROKKO',
		'MOZAMBIQUE' => 'MOSAMBIK',
		'MYANAMAR' => 'MYANAMAR',
		'NAMIBIA' => 'NAMIBIA',
		'NEPAL' => 'NEPAL',
		'NETHERLANDS' => 'NIEDERLANDE',
		'NETHERLANDS ANTILLES' => 'NIEDERLÄNDISCHE ANTILLEN',
		'NETHERLANDS ANTILLES NEUTRAL ZONE' => 'NIEDERLÄNDISCHE ANTILLEN NEUTRALE ZONE',
		'NEW CALADONIA' => 'NEU KALEDONIEN',
		'NEW HEBRIDES' => 'NEUE HEBRIDEN',
		'NEW ZEALAND' => 'NEUSEELAND',
		'NICARAGUA' => 'NIKARAGUA',
		'NIGER' => 'NIGER',
		'NIGERIA' => 'NIGERIA',
		'NORFOLK ISLAND' => 'NORFOLK-INSELN',
		'NORWAY' => 'NORWEGEN',
		'OMAN' => 'OMAN',
		'OTHER' => 'ANDERE',
		'PACIFIC ISLAND' => 'PAZIFISCE-INSEL',
		'PAKISTAN' => 'PAKISTAN',
		'PANAMA' => 'PANAMA',
		'PAPUA NEW GUINEA' => 'PAPUA NEUGUINEA',
		'PARAGUAY' => 'PARAGUAY',
		'PERU' => 'PERU',
		'PHILIPPINES' => 'PHILIPPINEN',
		'POLAND' => 'POLEN',
		'PORTUGAL' => 'PORTUGAL',
		'PORTUGUESE TIMOR' => 'PORTUGUESE TIMOR',
		'PUERTO RICO' => 'PUERTO RICO',
		'QATAR' => 'QATAR',
		'REPUBLIC OF BELARUS' => 'WEISSRUSSLAND',
		'REPUBLIC OF SOUTH AFRICA' => 'REPUBLIK SÜDAFRIKA',
		'REUNION' => 'REUNION',
		'ROMANIA' => 'RUMÄNIEN',
		'RUSSIA' => 'RUSSLAND',
		'RWANDA' => 'RWANDA',
		'RYUKYU ISLANDS' => 'RYUKYU-INSELN',
		'SABAH' => 'SABAH',
		'SAN MARINO' => 'SAN MARINO',
		'SAUDI ARABIA' => 'SAUDI-ARABIEN',
		'SENEGAL' => 'SENEGAL',
		'SERBIA' => 'SERBIEN',
		'SEYCHELLES' => 'SEYCHELLEN',
		'SIERRA LEONE' => 'SIERRA LEONE',
		'SINGAPORE' => 'SINGAPUR',
		'SLOVAKIA' => 'SLOWAKEI',
		'SLOVENIA' => 'SLOWENIEN',
		'SOMALILIAND' => 'SOMALILIAND',
		'SOUTH AFRICA' => 'SÜDAFRIKA',
		'SOUTH YEMEN' => 'SÜD JEMEN',
		'SPAIN' => 'SPANIEN',
		'SPANISH SAHARA' => 'SPANISCHE SAHARA',
		'SRI LANKA' => 'SRI LANKA',
		'ST. KITTS AND NEVIS' => 'ST. KITTS AND NEVIS',
		'ST. LUCIA' => 'ST. LUCIA',
		'SUDAN' => 'SUDAN',
		'SURINAM' => 'SURINAM',
		'SW AFRICA' => 'SW AFRIKA',
		'SWAZILAND' => 'SWAZILAND',
		'SWEDEN' => 'SCHWEDEN',
		'SWITZERLAND' => 'SCHWEIZ',
		'SYRIA' => 'SYRIEN',
		'TAIWAN' => 'TAIWAN',
		'TAJIKISTAN' => 'TADSCHIKISTAN',
		'TANZANIA' => 'TANSANIA',
		'THAILAND' => 'THAILAND',
		'TONGA' => 'TONGA',
		'TRINIDAD' => 'TRINIDAD',
		'TUNISIA' => 'TUNESIEN',
		'TURKEY' => 'TÜRKEI',
		'UGANDA' => 'UGANDA',
		'UKRAINE' => 'UKRAINE',
		'UNITED ARAB EMIRATES' => 'VEREINIGTE ARABISCHE EMIRATE',
		'UNITED KINGDOM' => 'GROSSBRITANNIEN (VEREINIGTES KÖNIGREICH)',
		'UPPER VOLTA' => 'OBERVOLTA',
		'URUGUAY' => 'URUGUAY',
		'US PACIFIC ISLAND' => 'US PAZIFISCHE-INSEL',
		'US VIRGIN ISLANDS' => 'US VIRGIN INSELN',
		'USA' => 'VEREINIGTE STAATEN (USA)',
		'UZBEKISTAN' => 'UZBEKISTAN',
		'VANUATU' => 'VANUATU',
		'VATICAN CITY' => 'VATIKANSTADT',
		'VENEZUELA' => 'VENEZUELA',
		'VIETNAM' => 'VIETNAM',
		'WAKE ISLAND' => 'WAKE ISLAND',
		'WEST INDIES' => 'WEST INDIES',
		'WESTERN SAHARA' => 'WESTSAHARA',
		'YEMEN' => 'JEMEN',
		'ZAIRE' => 'ZAIRE',
		'ZAMBIA' => 'SAMBIA',
		'ZIMBABWE' => 'SIMBABWE',
	);

?>
