<?php
/*********************************************************************************
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/


/**
 * UpgradeRemoval65x.php
 * @author Justin Park
 * This file contains the code to assit with removal of files during a 65x upgrade
 *
 */
require_once('modules/UpgradeWizard/UpgradeRemoval.php');

class UpgradeRemoval65x extends UpgradeRemoval
{
    /**
     * @var string minimal version for removal
     */
    public $version = '6.5.0';

    /**
     * getFilesToRemove
     * Return an array of files/directories to remove for 65x upgrades
     * @param unknown_type $version
     */
    public function getFilesToRemove($version)
    {
        $files = array();

        $files[] = 'custom/modules/Accounts/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/ACLActions/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Administration/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Bugs/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Calendar/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Calls/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Campaigns/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Cases/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Contacts/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Documents/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Emails/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/EmailTemplates/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Leads/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Meetings/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/ModuleBuilder/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Notes/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Opportunities/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Project/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/ProjectTask/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/ProspectLists/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Prospects/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Tasks/Ext/Language/ru_ru.lang.ext.php';
        $files[] = 'custom/modules/Users/Ext/Language/ru_ru.lang.ext.php';

        $files[] = 'custom/Extension/modules/Accounts/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/ACLActions/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Administration/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Bugs/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Calendar/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Calls/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Campaigns/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Cases/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Contacts/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Documents/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Emails/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/EmailTemplates/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Leads/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Meetings/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/ModuleBuilder/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Notes/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Opportunities/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Project/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/ProjectTask/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/ProspectLists/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Prospects/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Tasks/Ext/Language/ru_ru.SecurityGroups.php';
        $files[] = 'custom/Extension/modules/Users/Ext/Language/ru_ru.SecurityGroups.php';

        return $files;
    }


}
