<?php
/*********************************************************************************
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 ********************************************************************************/


/**
 * UpgradeRemoval64x.php
 * @author Collin Lee
 * This file contains the code to assit with removal of files during a 64x upgrade
 *
 */
require_once('modules/UpgradeWizard/UpgradeRemoval.php');

class UpgradeRemoval64x extends UpgradeRemoval
{
    /**
     * @var string minimal version for removal
     */
    public $version = '6.4.0';

/**
 * getFilesToRemove
 * Return an array of files/directories to remove for 64x upgrades
 * @param unknown_type $version
 */	
public function getFilesToRemove($version)
{
$files = array();

// In 6.4.0 we did the following
// 1) Removed from include/javascript/yui3/assets dpSyntaxHighlighter.css and dpSyntaxHighlighter.js files

if (version_compare($version, $this->version, '<'))
{
	$files[] = 'include/javascript/yui3/assets/dpSyntaxHighligther.css';
	$files[] = 'include/javascript/yui3/assets/dpSyntaxHighligther.js';
	$files[] = 'modules/Users/DetailView.html';
	$files[] = 'modules/Users/EditView.html';
	$files[] = 'modules/Users/DetailView.php';
	$files[] = 'modules/Users/EditView.php';

    //Remove files from the modules/DocumentRevisions directory
    $files[] = 'modules/DocumentRevisions/DetailView.php';
    $files[] = 'modules/DocumentRevisions/DetailView.html';
   	$files[] = 'modules/DocumentRevisions/EditView.html';
   	$files[] = 'modules/DocumentRevisions/EditView.php';

    //Remove files from the include/database directory
    $files[] = 'include/database/MysqliHelper.php';
    $files[] = 'include/database/PearDatabase.php';
    $files[] = 'include/database/SqlsrvHelper.php';

    //Remove grouping js & css files
    $files[] = 'include/javascript/sugar_grp1.js';
    $files[] = 'include/javascript/sugar_grp1_yui.js';
    $files[] = 'include/javascript/sugar_grp_emails.js';
    $files[] = 'include/javascript/sugar_grp_jsolait.js';
    $files[] = 'include/javascript/sugar_grp_overlib.js';
    $files[] = 'include/javascript/sugar_grp_quickcomp.js';
    $files[] = 'include/javascript/sugar_grp_yui2.js';
    $files[] = 'include/javascript/sugar_grp_yui_widgets.css';
    $files[] = 'include/javascript/sugar_grp_yui_widgets.js';

    $files[] = 'data/upload/index.html';

}

return $files;	
}
	
		
}
